/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.decorator.HttpStatusConverter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.utils.NetPeerUtils;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.attributes.SemanticAttributes;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HttpClientTracer<REQUEST, CARRIER, RESPONSE>
extends BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpClientTracer.class);
    public static final String DEFAULT_SPAN_NAME = "HTTP request";
    protected static final String USER_AGENT = "User-Agent";

    protected abstract String method(REQUEST var1);

    protected abstract @Nullable URI url(REQUEST var1) throws URISyntaxException;

    protected @Nullable String flavor(REQUEST request) {
        return "1.1";
    }

    protected abstract Integer status(RESPONSE var1);

    protected abstract @Nullable String requestHeader(REQUEST var1, String var2);

    protected abstract @Nullable String responseHeader(RESPONSE var1, String var2);

    protected abstract TextMapPropagator.Setter<CARRIER> getSetter();

    protected HttpClientTracer() {
    }

    protected HttpClientTracer(Tracer tracer) {
        super(tracer);
    }

    public Span startSpan(REQUEST request) {
        return this.startSpan(request, -1L);
    }

    public Span startSpan(REQUEST request, long startTimeNanos) {
        return this.startSpan(request, this.spanNameForRequest(request), startTimeNanos);
    }

    public Scope startScope(Span span, CARRIER carrier) {
        Context context = TracingContextUtils.withSpan(span, Context.current());
        TextMapPropagator.Setter<CARRIER> setter = this.getSetter();
        if (setter == null) {
            throw new IllegalStateException("getSetter() not defined but calling startScope(), either getSetter must be implemented or the scope should be setup manually");
        }
        OpenTelemetry.getPropagators().getTextMapPropagator().inject(context, carrier, setter);
        context = context.withValue(CONTEXT_CLIENT_SPAN_KEY, span);
        return ContextUtils.withScopedContext(context);
    }

    public void end(Span span, RESPONSE response) {
        this.end(span, response, -1L);
    }

    public void end(Span span, RESPONSE response, long endTimeNanos) {
        this.onResponse(span, response);
        super.end(span, endTimeNanos);
    }

    public void endExceptionally(Span span, RESPONSE response, Throwable throwable) {
        this.endExceptionally(span, response, throwable, -1L);
    }

    public void endExceptionally(Span span, RESPONSE response, Throwable throwable, long endTimeNanos) {
        this.onResponse(span, response);
        super.endExceptionally(span, throwable, endTimeNanos);
    }

    private Span startSpan(REQUEST request, String name, long startTimeNanos) {
        Context context = Context.current();
        Span clientSpan = (Span)CONTEXT_CLIENT_SPAN_KEY.get(context);
        if (clientSpan != null) {
            return DefaultSpan.getInvalid();
        }
        Span.Builder spanBuilder = this.tracer.spanBuilder(name).setSpanKind(Span.Kind.CLIENT).setParent(context);
        if (startTimeNanos > 0L) {
            spanBuilder.setStartTimestamp(startTimeNanos);
        }
        Span span = spanBuilder.startSpan();
        this.onRequest(span, request);
        return span;
    }

    protected Span onRequest(Span span, REQUEST request) {
        assert (span != null);
        if (request != null) {
            span.setAttribute(SemanticAttributes.NET_TRANSPORT, "IP.TCP");
            span.setAttribute(SemanticAttributes.HTTP_METHOD, this.method(request));
            span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, this.requestHeader(request, USER_AGENT));
            this.setFlavor(span, request);
            this.setUrl(span, request);
        }
        return span;
    }

    private void setFlavor(Span span, REQUEST request) {
        String flavor = this.flavor(request);
        if (flavor == null) {
            return;
        }
        String httpProtocolPrefix = "HTTP/";
        if (flavor.startsWith(httpProtocolPrefix)) {
            flavor = flavor.substring(httpProtocolPrefix.length());
        }
        span.setAttribute(SemanticAttributes.HTTP_FLAVOR, flavor);
    }

    private void setUrl(Span span, REQUEST request) {
        try {
            URI url = this.url(request);
            if (url != null) {
                NetPeerUtils.setNetPeer(span, url.getHost(), null, url.getPort());
                span.setAttribute(SemanticAttributes.HTTP_URL, url.toString());
            }
        }
        catch (Exception e) {
            log.debug("Error tagging url", e);
        }
    }

    protected Span onResponse(Span span, RESPONSE response) {
        assert (span != null);
        if (response != null) {
            Integer status = this.status(response);
            if (status != null) {
                span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, Long.valueOf(status.intValue()));
                span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
            }
            String responseHeader = this.responseHeader(response, "Request-Context");
            HttpClientTracer.setTargetAppId(span, responseHeader);
        }
        return span;
    }

    protected String spanNameForRequest(REQUEST request) {
        if (request == null) {
            return DEFAULT_SPAN_NAME;
        }
        String method = this.method(request);
        return method != null ? "HTTP " + method : DEFAULT_SPAN_NAME;
    }

    private static void setTargetAppId(Span span, String responseHeader) {
        if (responseHeader == null) {
            return;
        }
        int index = responseHeader.indexOf(61);
        if (index == -1) {
            return;
        }
        String targetAppId = responseHeader.substring(index + 1);
        span.setAttribute("ai.target.appId", targetAppId);
    }
}

