/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.context.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.instrumentation.api.decorator.HttpStatusConverter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.attributes.SemanticAttributes;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HttpServerTracer<REQUEST, RESPONSE, CONNECTION, STORAGE>
extends BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerTracer.class);
    public static final String CONTEXT_ATTRIBUTE = "io.opentelemetry.instrumentation.context";
    protected static final String USER_AGENT = "User-Agent";
    private static final boolean FAIL_ON_CONTEXT_LEAK = Boolean.getBoolean("otel.internal.failOnContextLeak");
    protected static final String AI_REQUEST_CONTEXT_HEADER_NAME = "Request-Context";
    private static final boolean AI_BACK_COMPAT = true;
    private static final String AI_REQUEST_CONTEXT_HEADER_APPID_KEY = "appId";

    public HttpServerTracer() {
    }

    public HttpServerTracer(Tracer tracer) {
        super(tracer);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, Method origin) {
        String spanName = this.spanNameForMethod(origin);
        return this.startSpan(request, connection, spanName);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, String spanName) {
        return this.startSpan(request, connection, spanName, -1L);
    }

    public Span startSpan(REQUEST request, CONNECTION connection, String spanName, long startTimestamp) {
        Span.Builder builder = this.tracer.spanBuilder(spanName).setSpanKind(Span.Kind.SERVER).setParent(this.extract(request, this.getGetter()));
        if (startTimestamp >= 0L) {
            builder.setStartTimestamp(startTimestamp);
        }
        Span span = builder.startSpan();
        this.onConnection(span, connection);
        this.onRequest(span, request);
        this.onConnectionAndRequest(span, connection, request);
        return span;
    }

    public Scope startScope(Span span, STORAGE storage) {
        return this.startScope(span, storage, Context.current());
    }

    public Scope startScope(Span span, STORAGE storage, Context context) {
        Context newContext = TracingContextUtils.withSpan(span, context.withValue(CONTEXT_SERVER_SPAN_KEY, span));
        this.attachServerContext(newContext, storage);
        return ContextUtils.withScopedContext(newContext);
    }

    public void end(Span span, RESPONSE response) {
        this.end(span, response, -1L);
    }

    public void end(Span span, RESPONSE response, long timestamp) {
        HttpServerTracer.setStatus(span, this.responseStatus(response));
        HttpServerTracer.endSpan(span, timestamp);
    }

    @Override
    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, null);
    }

    public void endExceptionally(Span span, Throwable throwable, RESPONSE response) {
        this.endExceptionally(span, throwable, response, -1L);
    }

    public void endExceptionally(Span span, Throwable throwable, RESPONSE response, long timestamp) {
        this.onError(span, this.unwrapThrowable(throwable));
        if (response == null) {
            HttpServerTracer.setStatus(span, 500);
        } else {
            HttpServerTracer.setStatus(span, this.responseStatus(response));
        }
        HttpServerTracer.endSpan(span, timestamp);
    }

    public Span getServerSpan(STORAGE storage) {
        Context attachedContext = this.getServerContext(storage);
        return attachedContext == null ? null : (Span)CONTEXT_SERVER_SPAN_KEY.get(attachedContext);
    }

    public abstract @Nullable Context getServerContext(STORAGE var1);

    protected void onConnection(Span span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.NET_PEER_IP, this.peerHostIP(connection));
        Integer port = this.peerPort(connection);
        if (port != null && port > 0) {
            span.setAttribute(SemanticAttributes.NET_PEER_PORT, Long.valueOf(port.intValue()));
        }
    }

    protected void onRequest(Span span, REQUEST request) {
        String sourceAppId = span.getContext().getTraceState().get("az");
        if (sourceAppId != null && !sourceAppId.isEmpty()) {
            span.setAttribute("ai.source.appId", sourceAppId);
        } else {
            Map<String, String> map;
            String backCompatSourceAppId;
            String aiRequestContext = this.aiRequestContext(request);
            if (aiRequestContext != null && (backCompatSourceAppId = (map = HttpServerTracer.toMap(aiRequestContext)).get(AI_REQUEST_CONTEXT_HEADER_APPID_KEY)) != null && !backCompatSourceAppId.isEmpty()) {
                span.setAttribute("ai.source.appId", backCompatSourceAppId);
            }
        }
        span.setAttribute(SemanticAttributes.HTTP_METHOD, this.method(request));
        span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, this.requestHeader(request, USER_AGENT));
        this.setUrl(span, request);
    }

    private void setUrl(Span span, REQUEST request) {
        span.setAttribute(SemanticAttributes.HTTP_URL, this.url(request));
    }

    protected void onConnectionAndRequest(Span span, CONNECTION connection, REQUEST request) {
        String flavor = this.flavor(connection, request);
        if (flavor != null) {
            span.setAttribute(SemanticAttributes.HTTP_FLAVOR, flavor);
        }
        span.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, this.clientIP(connection, request));
    }

    private String clientIP(CONNECTION connection, REQUEST request) {
        String forwarded = this.requestHeader(request, "Forwarded");
        if (forwarded != null && (forwarded = HttpServerTracer.extractForwardedFor(forwarded)) != null) {
            return forwarded;
        }
        forwarded = this.requestHeader(request, "X-Forwarded-For");
        if (forwarded != null) {
            int endIndex = forwarded.indexOf(44);
            if (endIndex > 0) {
                forwarded = forwarded.substring(0, endIndex);
            }
            if (!forwarded.isEmpty()) {
                return forwarded;
            }
        }
        return this.peerHostIP(connection);
    }

    static String extractForwardedFor(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private <C> Context extract(C carrier, TextMapPropagator.Getter<C> getter) {
        if (ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            this.debugContextLeak();
        }
        return OpenTelemetry.getPropagators().getTextMapPropagator().extract(Context.ROOT, carrier, getter);
    }

    private void debugContextLeak() {
        Context current = Context.current();
        if (current != Context.ROOT) {
            List<StackTraceElement[]> locations;
            log.error("Unexpected non-root current context found when extracting remote context!");
            Span currentSpan = TracingContextUtils.getSpanWithoutDefault(current);
            if (currentSpan != null) {
                log.error("It contains this span: {}", (Object)currentSpan);
            }
            if ((locations = ContextPropagationDebug.getLocations(current)) != null) {
                StringBuilder sb = new StringBuilder();
                Iterator<StackTraceElement[]> i = locations.iterator();
                while (i.hasNext()) {
                    for (StackTraceElement ste : i.next()) {
                        sb.append("\n");
                        sb.append(ste);
                    }
                    if (!i.hasNext()) continue;
                    sb.append("\nwhich was propagated from:");
                }
                log.error("a context leak was detected. it was propagated from:{}", (Object)sb);
            }
            if (FAIL_ON_CONTEXT_LEAK) {
                throw new IllegalStateException("Context leak detected");
            }
        }
    }

    private static void setStatus(Span span, int status) {
        span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, Long.valueOf(status));
        span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
    }

    private static void endSpan(Span span, long timestamp) {
        if (timestamp >= 0L) {
            span.end(EndSpanOptions.builder().setEndTimestamp(timestamp).build());
        } else {
            span.end();
        }
    }

    protected abstract @Nullable Integer peerPort(CONNECTION var1);

    protected abstract @Nullable String peerHostIP(CONNECTION var1);

    protected abstract String flavor(CONNECTION var1, REQUEST var2);

    protected abstract TextMapPropagator.Getter<REQUEST> getGetter();

    protected abstract String url(REQUEST var1);

    protected abstract String method(REQUEST var1);

    protected abstract @Nullable String requestHeader(REQUEST var1, String var2);

    protected abstract int responseStatus(RESPONSE var1);

    protected abstract void attachServerContext(Context var1, STORAGE var2);

    protected boolean isRelativeUrl(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://");
    }

    protected String aiRequestContext(REQUEST request) {
        return null;
    }

    private static Map<String, String> toMap(String str) {
        String[] pairs;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String pair : pairs = str.split(",")) {
            String[] keyValuePair = pair.trim().split("=");
            if (keyValuePair.length != 2) continue;
            String key = keyValuePair[0].trim();
            String value = keyValuePair[1].trim();
            result.put(key, value);
        }
        return result;
    }
}

