/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan;

import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.DbSemanticConvention;
import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.DelegatingSpan;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;

public class DbSpan
extends DelegatingSpan
implements DbSemanticConvention {
    protected DbSpan(Span span) {
        super(span);
    }

    public static DbSpanBuilder createDbSpan(Tracer tracer, String spanName) {
        return new DbSpanBuilder(tracer, spanName).setKind(Span.Kind.CLIENT);
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public DbSemanticConvention setDbSystem(String dbSystem) {
        this.delegate.setAttribute("db.system", dbSystem);
        return this;
    }

    @Override
    public DbSemanticConvention setDbConnectionString(String dbConnectionString) {
        this.delegate.setAttribute("db.connection_string", dbConnectionString);
        return this;
    }

    @Override
    public DbSemanticConvention setDbUser(String dbUser) {
        this.delegate.setAttribute("db.user", dbUser);
        return this;
    }

    @Override
    public DbSemanticConvention setDbJdbcDriverClassname(String dbJdbcDriverClassname) {
        this.delegate.setAttribute("db.jdbc.driver_classname", dbJdbcDriverClassname);
        return this;
    }

    @Override
    public DbSemanticConvention setDbName(String dbName) {
        this.delegate.setAttribute("db.name", dbName);
        return this;
    }

    @Override
    public DbSemanticConvention setDbStatement(String dbStatement) {
        this.delegate.setAttribute("db.statement", dbStatement);
        return this;
    }

    @Override
    public DbSemanticConvention setDbOperation(String dbOperation) {
        this.delegate.setAttribute("db.operation", dbOperation);
        return this;
    }

    @Override
    public DbSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public DbSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public DbSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public DbSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    public static class DbSpanBuilder {
        protected Span.Builder internalBuilder;

        protected DbSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public DbSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public DbSpanBuilder setParent(Context context) {
            this.internalBuilder.setParent(context);
            return this;
        }

        public DbSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public DbSpan start() {
            return new DbSpan(this.internalBuilder.startSpan());
        }

        public DbSpanBuilder setDbSystem(String dbSystem) {
            this.internalBuilder.setAttribute("db.system", dbSystem);
            return this;
        }

        public DbSpanBuilder setDbConnectionString(String dbConnectionString) {
            this.internalBuilder.setAttribute("db.connection_string", dbConnectionString);
            return this;
        }

        public DbSpanBuilder setDbUser(String dbUser) {
            this.internalBuilder.setAttribute("db.user", dbUser);
            return this;
        }

        public DbSpanBuilder setDbJdbcDriverClassname(String dbJdbcDriverClassname) {
            this.internalBuilder.setAttribute("db.jdbc.driver_classname", dbJdbcDriverClassname);
            return this;
        }

        public DbSpanBuilder setDbName(String dbName) {
            this.internalBuilder.setAttribute("db.name", dbName);
            return this;
        }

        public DbSpanBuilder setDbStatement(String dbStatement) {
            this.internalBuilder.setAttribute("db.statement", dbStatement);
            return this;
        }

        public DbSpanBuilder setDbOperation(String dbOperation) {
            this.internalBuilder.setAttribute("db.operation", dbOperation);
            return this;
        }

        public DbSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public DbSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public DbSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public DbSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }
    }
}

