/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan;

import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.DelegatingSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.HttpClientSemanticConvention;
import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.HttpSpan;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;

public class HttpClientSpan
extends DelegatingSpan
implements HttpClientSemanticConvention {
    protected HttpClientSpan(Span span) {
        super(span);
    }

    public static HttpClientSpanBuilder createHttpClientSpan(Tracer tracer, String spanName) {
        return new HttpClientSpanBuilder(tracer, spanName).setKind(Span.Kind.CLIENT);
    }

    public static HttpClientSpanBuilder createHttpClientSpan(HttpSpan.HttpSpanBuilder builder) {
        return new HttpClientSpanBuilder(builder.getSpanBuilder());
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public HttpClientSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setNetHostIp(String netHostIp) {
        this.delegate.setAttribute("net.host.ip", netHostIp);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setNetHostPort(long netHostPort) {
        this.delegate.setAttribute("net.host.port", netHostPort);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setNetHostName(String netHostName) {
        this.delegate.setAttribute("net.host.name", netHostName);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpMethod(String httpMethod) {
        this.delegate.setAttribute("http.method", httpMethod);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpUrl(String httpUrl) {
        this.delegate.setAttribute("http.url", httpUrl);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpTarget(String httpTarget) {
        this.delegate.setAttribute("http.target", httpTarget);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpHost(String httpHost) {
        this.delegate.setAttribute("http.host", httpHost);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpScheme(String httpScheme) {
        this.delegate.setAttribute("http.scheme", httpScheme);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpStatusCode(long httpStatusCode) {
        this.delegate.setAttribute("http.status_code", httpStatusCode);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpStatusText(String httpStatusText) {
        this.delegate.setAttribute("http.status_text", httpStatusText);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpFlavor(String httpFlavor) {
        this.delegate.setAttribute("http.flavor", httpFlavor);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpUserAgent(String httpUserAgent) {
        this.delegate.setAttribute("http.user_agent", httpUserAgent);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpRequestContentLength(long httpRequestContentLength) {
        this.delegate.setAttribute("http.request_content_length", httpRequestContentLength);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpRequestContentLengthUncompressed(long httpRequestContentLengthUncompressed) {
        this.delegate.setAttribute("http.request_content_length_uncompressed", httpRequestContentLengthUncompressed);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpResponseContentLength(long httpResponseContentLength) {
        this.delegate.setAttribute("http.response_content_length", httpResponseContentLength);
        return this;
    }

    @Override
    public HttpClientSemanticConvention setHttpResponseContentLengthUncompressed(long httpResponseContentLengthUncompressed) {
        this.delegate.setAttribute("http.response_content_length_uncompressed", httpResponseContentLengthUncompressed);
        return this;
    }

    public static class HttpClientSpanBuilder {
        protected Span.Builder internalBuilder;

        protected HttpClientSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public HttpClientSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public HttpClientSpanBuilder setParent(Context context) {
            this.internalBuilder.setParent(context);
            return this;
        }

        public HttpClientSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public HttpClientSpan start() {
            return new HttpClientSpan(this.internalBuilder.startSpan());
        }

        public HttpClientSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }

        public HttpClientSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public HttpClientSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public HttpClientSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public HttpClientSpanBuilder setNetHostIp(String netHostIp) {
            this.internalBuilder.setAttribute("net.host.ip", netHostIp);
            return this;
        }

        public HttpClientSpanBuilder setNetHostPort(long netHostPort) {
            this.internalBuilder.setAttribute("net.host.port", netHostPort);
            return this;
        }

        public HttpClientSpanBuilder setNetHostName(String netHostName) {
            this.internalBuilder.setAttribute("net.host.name", netHostName);
            return this;
        }

        public HttpClientSpanBuilder setHttpMethod(String httpMethod) {
            this.internalBuilder.setAttribute("http.method", httpMethod);
            return this;
        }

        public HttpClientSpanBuilder setHttpUrl(String httpUrl) {
            this.internalBuilder.setAttribute("http.url", httpUrl);
            return this;
        }

        public HttpClientSpanBuilder setHttpTarget(String httpTarget) {
            this.internalBuilder.setAttribute("http.target", httpTarget);
            return this;
        }

        public HttpClientSpanBuilder setHttpHost(String httpHost) {
            this.internalBuilder.setAttribute("http.host", httpHost);
            return this;
        }

        public HttpClientSpanBuilder setHttpScheme(String httpScheme) {
            this.internalBuilder.setAttribute("http.scheme", httpScheme);
            return this;
        }

        public HttpClientSpanBuilder setHttpStatusCode(long httpStatusCode) {
            this.internalBuilder.setAttribute("http.status_code", httpStatusCode);
            return this;
        }

        public HttpClientSpanBuilder setHttpStatusText(String httpStatusText) {
            this.internalBuilder.setAttribute("http.status_text", httpStatusText);
            return this;
        }

        public HttpClientSpanBuilder setHttpFlavor(String httpFlavor) {
            this.internalBuilder.setAttribute("http.flavor", httpFlavor);
            return this;
        }

        public HttpClientSpanBuilder setHttpUserAgent(String httpUserAgent) {
            this.internalBuilder.setAttribute("http.user_agent", httpUserAgent);
            return this;
        }

        public HttpClientSpanBuilder setHttpRequestContentLength(long httpRequestContentLength) {
            this.internalBuilder.setAttribute("http.request_content_length", httpRequestContentLength);
            return this;
        }

        public HttpClientSpanBuilder setHttpRequestContentLengthUncompressed(long httpRequestContentLengthUncompressed) {
            this.internalBuilder.setAttribute("http.request_content_length_uncompressed", httpRequestContentLengthUncompressed);
            return this;
        }

        public HttpClientSpanBuilder setHttpResponseContentLength(long httpResponseContentLength) {
            this.internalBuilder.setAttribute("http.response_content_length", httpResponseContentLength);
            return this;
        }

        public HttpClientSpanBuilder setHttpResponseContentLengthUncompressed(long httpResponseContentLengthUncompressed) {
            this.internalBuilder.setAttribute("http.response_content_length_uncompressed", httpResponseContentLengthUncompressed);
            return this;
        }
    }
}

