/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan;

import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.DelegatingSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.HttpServerSemanticConvention;
import io.opentelemetry.javaagent.shaded.instrumentation.api.typedspan.HttpSpan;
import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;

public class HttpServerSpan
extends DelegatingSpan
implements HttpServerSemanticConvention {
    protected HttpServerSpan(Span span) {
        super(span);
    }

    public static HttpServerSpanBuilder createHttpServerSpan(Tracer tracer, String spanName) {
        return new HttpServerSpanBuilder(tracer, spanName).setKind(Span.Kind.SERVER);
    }

    public static HttpServerSpanBuilder createHttpServerSpan(HttpSpan.HttpSpanBuilder builder) {
        return new HttpServerSpanBuilder(builder.getSpanBuilder());
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public HttpServerSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setNetHostIp(String netHostIp) {
        this.delegate.setAttribute("net.host.ip", netHostIp);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setNetHostPort(long netHostPort) {
        this.delegate.setAttribute("net.host.port", netHostPort);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setNetHostName(String netHostName) {
        this.delegate.setAttribute("net.host.name", netHostName);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpMethod(String httpMethod) {
        this.delegate.setAttribute("http.method", httpMethod);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpUrl(String httpUrl) {
        this.delegate.setAttribute("http.url", httpUrl);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpTarget(String httpTarget) {
        this.delegate.setAttribute("http.target", httpTarget);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpHost(String httpHost) {
        this.delegate.setAttribute("http.host", httpHost);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpScheme(String httpScheme) {
        this.delegate.setAttribute("http.scheme", httpScheme);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpStatusCode(long httpStatusCode) {
        this.delegate.setAttribute("http.status_code", httpStatusCode);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpStatusText(String httpStatusText) {
        this.delegate.setAttribute("http.status_text", httpStatusText);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpFlavor(String httpFlavor) {
        this.delegate.setAttribute("http.flavor", httpFlavor);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpUserAgent(String httpUserAgent) {
        this.delegate.setAttribute("http.user_agent", httpUserAgent);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpRequestContentLength(long httpRequestContentLength) {
        this.delegate.setAttribute("http.request_content_length", httpRequestContentLength);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpRequestContentLengthUncompressed(long httpRequestContentLengthUncompressed) {
        this.delegate.setAttribute("http.request_content_length_uncompressed", httpRequestContentLengthUncompressed);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpResponseContentLength(long httpResponseContentLength) {
        this.delegate.setAttribute("http.response_content_length", httpResponseContentLength);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpResponseContentLengthUncompressed(long httpResponseContentLengthUncompressed) {
        this.delegate.setAttribute("http.response_content_length_uncompressed", httpResponseContentLengthUncompressed);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpServerName(String httpServerName) {
        this.delegate.setAttribute("http.server_name", httpServerName);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpRoute(String httpRoute) {
        this.delegate.setAttribute("http.route", httpRoute);
        return this;
    }

    @Override
    public HttpServerSemanticConvention setHttpClientIp(String httpClientIp) {
        this.delegate.setAttribute("http.client_ip", httpClientIp);
        return this;
    }

    public static class HttpServerSpanBuilder {
        protected Span.Builder internalBuilder;

        protected HttpServerSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public HttpServerSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public HttpServerSpanBuilder setParent(Context context) {
            this.internalBuilder.setParent(context);
            return this;
        }

        public HttpServerSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public HttpServerSpan start() {
            return new HttpServerSpan(this.internalBuilder.startSpan());
        }

        public HttpServerSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }

        public HttpServerSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public HttpServerSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public HttpServerSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public HttpServerSpanBuilder setNetHostIp(String netHostIp) {
            this.internalBuilder.setAttribute("net.host.ip", netHostIp);
            return this;
        }

        public HttpServerSpanBuilder setNetHostPort(long netHostPort) {
            this.internalBuilder.setAttribute("net.host.port", netHostPort);
            return this;
        }

        public HttpServerSpanBuilder setNetHostName(String netHostName) {
            this.internalBuilder.setAttribute("net.host.name", netHostName);
            return this;
        }

        public HttpServerSpanBuilder setHttpMethod(String httpMethod) {
            this.internalBuilder.setAttribute("http.method", httpMethod);
            return this;
        }

        public HttpServerSpanBuilder setHttpUrl(String httpUrl) {
            this.internalBuilder.setAttribute("http.url", httpUrl);
            return this;
        }

        public HttpServerSpanBuilder setHttpTarget(String httpTarget) {
            this.internalBuilder.setAttribute("http.target", httpTarget);
            return this;
        }

        public HttpServerSpanBuilder setHttpHost(String httpHost) {
            this.internalBuilder.setAttribute("http.host", httpHost);
            return this;
        }

        public HttpServerSpanBuilder setHttpScheme(String httpScheme) {
            this.internalBuilder.setAttribute("http.scheme", httpScheme);
            return this;
        }

        public HttpServerSpanBuilder setHttpStatusCode(long httpStatusCode) {
            this.internalBuilder.setAttribute("http.status_code", httpStatusCode);
            return this;
        }

        public HttpServerSpanBuilder setHttpStatusText(String httpStatusText) {
            this.internalBuilder.setAttribute("http.status_text", httpStatusText);
            return this;
        }

        public HttpServerSpanBuilder setHttpFlavor(String httpFlavor) {
            this.internalBuilder.setAttribute("http.flavor", httpFlavor);
            return this;
        }

        public HttpServerSpanBuilder setHttpUserAgent(String httpUserAgent) {
            this.internalBuilder.setAttribute("http.user_agent", httpUserAgent);
            return this;
        }

        public HttpServerSpanBuilder setHttpRequestContentLength(long httpRequestContentLength) {
            this.internalBuilder.setAttribute("http.request_content_length", httpRequestContentLength);
            return this;
        }

        public HttpServerSpanBuilder setHttpRequestContentLengthUncompressed(long httpRequestContentLengthUncompressed) {
            this.internalBuilder.setAttribute("http.request_content_length_uncompressed", httpRequestContentLengthUncompressed);
            return this;
        }

        public HttpServerSpanBuilder setHttpResponseContentLength(long httpResponseContentLength) {
            this.internalBuilder.setAttribute("http.response_content_length", httpResponseContentLength);
            return this;
        }

        public HttpServerSpanBuilder setHttpResponseContentLengthUncompressed(long httpResponseContentLengthUncompressed) {
            this.internalBuilder.setAttribute("http.response_content_length_uncompressed", httpResponseContentLengthUncompressed);
            return this;
        }

        public HttpServerSpanBuilder setHttpServerName(String httpServerName) {
            this.internalBuilder.setAttribute("http.server_name", httpServerName);
            return this;
        }

        public HttpServerSpanBuilder setHttpRoute(String httpRoute) {
            this.internalBuilder.setAttribute("http.route", httpRoute);
            return this;
        }

        public HttpServerSpanBuilder setHttpClientIp(String httpClientIp) {
            this.internalBuilder.setAttribute("http.client_ip", httpClientIp);
            return this;
        }
    }
}

