/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.baggage.BaggageManager;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.baggage.DefaultBaggageManager;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.baggage.spi.BaggageManagerFactory;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.DefaultContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.internal.Obfuscated;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.metrics.DefaultMeterProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.metrics.MeterProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.metrics.spi.MeterProviderFactory;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.DefaultTracerProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TracerProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.spi.TracerProviderFactory;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetry {
    private static final Object mutex = new Object();
    @Nullable
    private static volatile OpenTelemetry instance;
    private final TracerProvider tracerProvider;
    private final MeterProvider meterProvider;
    private final BaggageManager contextManager;
    private volatile ContextPropagators propagators = DefaultContextPropagators.builder().build();

    public static TracerProvider getTracerProvider() {
        return OpenTelemetry.getInstance().tracerProvider;
    }

    public static Tracer getTracer(String instrumentationName) {
        return OpenTelemetry.getTracerProvider().get(instrumentationName);
    }

    public static Tracer getTracer(String instrumentationName, String instrumentationVersion) {
        return OpenTelemetry.getTracerProvider().get(instrumentationName, instrumentationVersion);
    }

    public static MeterProvider getMeterProvider() {
        return OpenTelemetry.getInstance().meterProvider;
    }

    public static Meter getMeter(String instrumentationName) {
        return OpenTelemetry.getMeterProvider().get(instrumentationName);
    }

    public static Meter getMeter(String instrumentationName, String instrumentationVersion) {
        return OpenTelemetry.getMeterProvider().get(instrumentationName, instrumentationVersion);
    }

    public static BaggageManager getBaggageManager() {
        return OpenTelemetry.getInstance().contextManager;
    }

    public static ContextPropagators getPropagators() {
        return OpenTelemetry.getInstance().propagators;
    }

    public static void setPropagators(ContextPropagators propagators) {
        Objects.requireNonNull(propagators, "propagators");
        OpenTelemetry.getInstance().propagators = propagators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenTelemetry getInstance() {
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                if (instance == null) {
                    instance = new OpenTelemetry();
                }
            }
        }
        return instance;
    }

    private OpenTelemetry() {
        TracerProviderFactory tracerProviderFactory = OpenTelemetry.loadSpi(TracerProviderFactory.class);
        this.tracerProvider = tracerProviderFactory != null ? new ObfuscatedTracerProvider(tracerProviderFactory.create()) : DefaultTracerProvider.getInstance();
        MeterProviderFactory meterProviderFactory = OpenTelemetry.loadSpi(MeterProviderFactory.class);
        this.meterProvider = meterProviderFactory != null ? meterProviderFactory.create() : DefaultMeterProvider.getInstance();
        BaggageManagerFactory contextManagerProvider = OpenTelemetry.loadSpi(BaggageManagerFactory.class);
        this.contextManager = contextManagerProvider != null ? contextManagerProvider.create() : DefaultBaggageManager.getInstance();
    }

    @Nullable
    private static <T> T loadSpi(Class<T> providerClass) {
        String specifiedProvider = System.getProperty(providerClass.getName());
        ServiceLoader<T> providers = ServiceLoader.load(providerClass);
        for (T provider : providers) {
            if (specifiedProvider != null && !specifiedProvider.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (specifiedProvider != null) {
            throw new IllegalStateException(String.format("Service provider %s not found", specifiedProvider));
        }
        return null;
    }

    static void reset() {
        instance = null;
    }

    @ThreadSafe
    private static class ObfuscatedTracerProvider
    implements TracerProvider,
    Obfuscated<TracerProvider> {
        private final TracerProvider delegate;

        private ObfuscatedTracerProvider(TracerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Tracer get(String instrumentationName) {
            return this.delegate.get(instrumentationName);
        }

        @Override
        public Tracer get(String instrumentationName, String instrumentationVersion) {
            return this.delegate.get(instrumentationName, instrumentationVersion);
        }

        @Override
        public TracerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

