/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.trace;

import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.internal.Utils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.TracingContextUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultTracer
implements Tracer {
    private static final DefaultTracer INSTANCE = new DefaultTracer();

    public static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public Span getCurrentSpan() {
        return TracingContextUtils.getCurrentSpan();
    }

    @Override
    public Scope withSpan(Span span) {
        return TracingContextUtils.currentContextWith(span);
    }

    @Override
    public Span.Builder spanBuilder(String spanName) {
        return NoopSpanBuilder.create(spanName);
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements Span.Builder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create(String spanName) {
            return new NoopSpanBuilder(spanName);
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = TracingContextUtils.getCurrentSpan().getContext();
            }
            return this.spanContext != null && !SpanContext.getInvalid().equals(this.spanContext) ? new DefaultSpan(this.spanContext) : DefaultSpan.getInvalid();
        }

        @Override
        public NoopSpanBuilder setParent(Context context) {
            Objects.requireNonNull(context, "context");
            this.spanContext = TracingContextUtils.getSpan(context).getContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public <T> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(Span.Kind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp) {
            Utils.checkArgument(startTimestamp >= 0L, "Negative startTimestamp");
            return this;
        }

        private NoopSpanBuilder(String name) {
            Objects.requireNonNull(name, "name");
        }
    }
}

