/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.trace;

import io.opentelemetry.javaagent.shaded.io.grpc.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.trace.Span;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TracingContextUtils {
    private static final Context.Key<Span> CONTEXT_SPAN_KEY = Context.key("opentelemetry-trace-span-key");

    public static Context withSpan(Span span, Context context) {
        return context.withValue(CONTEXT_SPAN_KEY, span);
    }

    public static Span getCurrentSpan() {
        return TracingContextUtils.getSpan(Context.current());
    }

    public static Span getSpan(Context context) {
        Span span = CONTEXT_SPAN_KEY.get(context);
        return span == null ? DefaultSpan.getInvalid() : span;
    }

    @Nullable
    public static Span getSpanWithoutDefault(Context context) {
        return CONTEXT_SPAN_KEY.get(context);
    }

    public static Scope currentContextWith(Span span) {
        return ContextUtils.withScopedContext(TracingContextUtils.withSpan(span, Context.current()));
    }

    private TracingContextUtils() {
    }
}

