/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.agent.internal.coresync.AgentNotificationsHandler;
import com.microsoft.applicationinsights.agent.internal.coresync.impl.ImplementationsCoordinator;
import com.microsoft.applicationinsights.internal.agent.CoreAgentNotificationsHandler;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;

public enum AgentConnector {
    INSTANCE;

    private String agentKey;
    private boolean registered = false;
    private CoreAgentNotificationsHandler coreDataAgent;

    public synchronized RegistrationResult register(ClassLoader classLoader, String name) {
        if (!this.registered) {
            try {
                this.coreDataAgent = new CoreAgentNotificationsHandler(name);
                this.agentKey = ImplementationsCoordinator.INSTANCE.register(classLoader, (AgentNotificationsHandler)this.coreDataAgent);
            }
            catch (Throwable t) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Could not find Agent: '%s'", t.getMessage());
                this.agentKey = null;
            }
            this.registered = true;
        }
        return new RegistrationResult(this.agentKey, this.coreDataAgent.getCleaner());
    }

    public static class RegistrationResult {
        private final String key;
        private final ThreadLocalCleaner cleaner;

        public RegistrationResult(String key, ThreadLocalCleaner cleaner) {
            this.key = key;
            this.cleaner = cleaner;
        }

        public String getKey() {
            return this.key;
        }

        public ThreadLocalCleaner getCleaner() {
            return this.cleaner;
        }
    }
}

