/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.agent.internal.coresync.AgentNotificationsHandler;
import com.microsoft.applicationinsights.agent.internal.coresync.InstrumentedClassType;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.schemav2.DependencyKind;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;

final class CoreAgentNotificationsHandler
implements AgentNotificationsHandler {
    private final ThreadLocalCleaner cleaner = new ThreadLocalCleaner(){

        @Override
        public void clean() {
            CoreAgentNotificationsHandler.this.threadDataThreadLocal.remove();
        }
    };
    private ThreadLocalData threadDataThreadLocal = new ThreadLocalData();
    private TelemetryClient telemetryClient = new TelemetryClient();
    private final String name;

    public ThreadLocalCleaner getCleaner() {
        return this.cleaner;
    }

    public CoreAgentNotificationsHandler(String name) {
        this.name = name;
    }

    public void onThrowable(String classAndMethodNames, Throwable throwable) {
        try {
            if (throwable instanceof Exception) {
                this.telemetryClient.trackException((Exception)throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public void onMethodEnterURL(String name, URL url) {
        String urlAsString = url == null ? null : url.toString();
        this.startMethod(InstrumentedClassType.HTTP, name, urlAsString);
    }

    public void onMethodEnterSqlStatement(String name, Statement statement, String sqlStatement) {
        if (statement == null) {
            return;
        }
        try {
            Connection connection = statement.getConnection();
            if (connection == null) {
                return;
            }
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData == null) {
                return;
            }
            String url = metaData.getURL();
            this.startMethod(InstrumentedClassType.SQL, name, url, sqlStatement);
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public void onMethodEnter(String name) {
        this.startMethod(InstrumentedClassType.OTHER, name, new String[0]);
    }

    public void onMethodFinish(String name, Throwable throwable) {
        this.finalizeMethod(null, throwable);
    }

    public void onMethodFinish(String name) {
        this.finalizeMethod(null, null);
    }

    private void startMethod(InstrumentedClassType type, String name, String ... arguments) {
        long start = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        MethodData methodData = new MethodData();
        methodData.interval = start;
        methodData.type = type;
        methodData.arguments = arguments;
        methodData.name = name;
        localData.methods.addFirst(methodData);
    }

    private void finalizeMethod(Object result, Throwable throwable) {
        long finish = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        if (localData.methods == null || localData.methods.isEmpty()) {
            InternalLogger.INSTANCE.error("Agent has detected a 'Finish' method event without a 'Start'", new Object[0]);
            return;
        }
        MethodData methodData = localData.methods.removeFirst();
        if (methodData == null) {
            return;
        }
        methodData.interval = finish - methodData.interval;
        methodData.result = result;
        this.report(methodData, throwable);
    }

    private void report(MethodData methodData, Throwable throwable) {
        switch (methodData.type) {
            case SQL: {
                this.sendSQLTelemetry(methodData, throwable);
                break;
            }
            case HTTP: {
                this.sendHTTPTelemetry(methodData, throwable);
                break;
            }
            default: {
                this.sendInstrumentationTelemetry(methodData, throwable);
            }
        }
    }

    private void sendInstrumentationTelemetry(MethodData methodData, Throwable throwable) {
        Duration duration = new Duration(CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval));
        RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(methodData.name, null, duration, throwable == null);
        telemetry.setDependencyKind(DependencyKind.Undefined);
        InternalLogger.INSTANCE.trace("Sending RDD event for '%s'", methodData.name);
        this.telemetryClient.track(telemetry);
        if (throwable != null) {
            ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
            this.telemetryClient.track(exceptionTelemetry);
        }
    }

    private void sendHTTPTelemetry(MethodData methodData, Throwable throwable) {
        if (methodData.arguments != null && methodData.arguments.length == 1) {
            String url = methodData.arguments[0];
            Duration duration = new Duration(CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval));
            InternalLogger.INSTANCE.trace("Sending HTTP RDD event, URL: '%s'", url);
            RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(url, null, duration, throwable == null);
            this.telemetryClient.trackDependency(telemetry);
        }
    }

    private void sendSQLTelemetry(MethodData methodData, Throwable throwable) {
        if (methodData.arguments != null && methodData.arguments.length == 2) {
            String dependencyName = methodData.arguments[0];
            String commandName = methodData.arguments[1];
            Duration duration = new Duration(CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval));
            InternalLogger.INSTANCE.trace("Sending Sql RDD event for '%s', command: '%s'", dependencyName, commandName);
            RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(dependencyName, commandName, duration, throwable == null);
            this.telemetryClient.track(telemetry);
        }
    }

    private static long nanoToMilliseconds(long nanoSeconds) {
        return nanoSeconds / 1000000L;
    }

    static final class ThreadLocalData
    extends ThreadLocal<ThreadData> {
        private ThreadData threadData;

        ThreadLocalData() {
        }

        @Override
        protected ThreadData initialValue() {
            this.threadData = new ThreadData();
            return this.threadData;
        }
    }

    private static class ThreadData {
        public final LinkedList<MethodData> methods = new LinkedList();

        private ThreadData() {
        }
    }

    private static class MethodData {
        public String name;
        public String[] arguments;
        public long interval;
        public InstrumentedClassType type;
        public Object result;

        private MethodData() {
        }
    }
}

