/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;

public final class Transmission
implements Serializable {
    private int version;
    private int numberOfSends;
    private int numberOfPersistence;
    private final byte[] content;
    private final String webContentType;
    private final String webContentEncodingType;

    public Transmission(byte[] content, String webContentType, String webContentEncodingType, int version) {
        Preconditions.checkNotNull((Object)content, (Object)"Content must be non-null value");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)webContentType) ? 1 : 0) != 0, (Object)"webContentType must be a non empty string");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)webContentEncodingType) ? 1 : 0) != 0, (Object)"webContentEncodingType must be a non empty string");
        this.numberOfPersistence = 0;
        this.numberOfSends = 0;
        this.version = version;
        this.content = content;
        this.webContentType = webContentType;
        this.webContentEncodingType = webContentEncodingType;
    }

    public Transmission(byte[] content, String webContentType, String webContentEncodingType) {
        this(content, webContentType, webContentEncodingType, 1);
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getWebContentType() {
        return this.webContentType;
    }

    public String getWebContentEncodingType() {
        return this.webContentEncodingType;
    }

    public void incrementNumberOfSends() {
        ++this.numberOfSends;
    }

    public void incrementNumberOfPersistence() {
        ++this.numberOfPersistence;
    }

    public int getNumberOfSends() {
        return this.numberOfSends;
    }

    public void setNumberOfSends(int numberOfSends) {
        this.numberOfSends = numberOfSends;
    }

    public int getNumberOfPersistence() {
        return this.numberOfPersistence;
    }

    public void setNumberOfPersistence(int numberOfPersistence) {
        this.numberOfPersistence = numberOfPersistence;
    }

    public int getVersion() {
        return this.version;
    }
}

