/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.internal.config.AppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.ApplicationInsightsXmlConfiguration;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

class JaxbAppInsightsConfigurationBuilder
implements AppInsightsConfigurationBuilder {
    JaxbAppInsightsConfigurationBuilder() {
    }

    @Override
    public ApplicationInsightsXmlConfiguration build(String filename) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationInsightsXmlConfiguration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File configurationFile = new File(filename);
            ApplicationInsightsXmlConfiguration applicationInsights = (ApplicationInsightsXmlConfiguration)unmarshaller.unmarshal(configurationFile);
            return applicationInsights;
        }
        catch (JAXBException e) {
            if (e.getCause() != null) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to parse configuration file '%s': '%s'", filename, e.getCause().getMessage());
            } else {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to parse configuration file '%s': '%s'", filename, e.getMessage());
            }
            return null;
        }
    }
}

