/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.logger;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.logger.ConsoleLoggerOutput;
import com.microsoft.applicationinsights.internal.logger.FileLoggerOutput;
import com.microsoft.applicationinsights.internal.logger.LoggerOutput;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public enum InternalLogger {
    INSTANCE;

    private static final String LOGGER_LEVEL = "Level";
    private static final SimpleDateFormat dateFormatter;
    private boolean initialized = false;
    private LoggingLevel loggingLevel = LoggingLevel.OFF;
    private LoggerOutput loggerOutput = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(String loggerOutputType, Map<String, String> loggerData) {
        if (!this.initialized) {
            try {
                String loggerLevel = loggerData.remove(LOGGER_LEVEL);
                if (Strings.isNullOrEmpty((String)loggerLevel)) {
                    this.loggingLevel = LoggingLevel.TRACE;
                    this.setLoggerOutput(loggerOutputType, loggerData);
                } else {
                    try {
                        this.loggingLevel = LoggingLevel.valueOf(loggerLevel.toUpperCase());
                        this.setLoggerOutput(loggerOutputType, loggerData);
                    }
                    catch (Exception e) {
                        this.onInitializationError(String.format("Error: Illegal value '%s' for the SDK internal logger. Logging level is therefore set to 'OFF'", loggerLevel));
                    }
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    public synchronized void stop() {
        if (this.loggingLevel.equals((Object)LoggingLevel.OFF)) {
            return;
        }
        try {
            if (this.loggerOutput != null) {
                this.loggerOutput.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.loggingLevel = LoggingLevel.OFF;
    }

    public boolean isTraceEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.TRACE.getValue();
    }

    public boolean isInfoEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.INFO.getValue();
    }

    public boolean isWarnEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.WARN.getValue();
    }

    public boolean isErrorEnabled() {
        return this.loggingLevel.getValue() <= LoggingLevel.ERROR.getValue();
    }

    public void error(String message, Object ... args) {
        try {
            this.log(LoggingLevel.ERROR, message, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void warn(String message, Object ... args) {
        try {
            this.log(LoggingLevel.WARN, message, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void info(String message, Object ... args) {
        try {
            this.log(LoggingLevel.INFO, message, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void trace(String message, Object ... args) {
        try {
            this.log(LoggingLevel.TRACE, message, args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void logAlways(LoggingLevel requestLevel, String message, Object ... args) {
        String logMessage = InternalLogger.createMessage(requestLevel.toString(), message, args);
        if (!this.initialized || this.loggerOutput == null) {
            new ConsoleLoggerOutput().log(logMessage);
        } else {
            this.loggerOutput.log(logMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createMessage(String prefix, String message, Object ... args) {
        String currentDateAsString;
        InternalLogger internalLogger = INSTANCE;
        synchronized (internalLogger) {
            currentDateAsString = dateFormatter.format(new Date());
        }
        String formattedMessage = String.format(message, args);
        String theMessage = String.format("%s %s, %d: %s", prefix, currentDateAsString, Thread.currentThread().getId(), formattedMessage);
        return theMessage;
    }

    private void setLoggerOutput(String loggerOutputType, Map<String, String> loggerData) {
        if (this.loggingLevel.equals((Object)LoggingLevel.OFF)) {
            this.loggerOutput = null;
            return;
        }
        LoggerOutputType type = LoggerOutputType.CONSOLE;
        if (!Strings.isNullOrEmpty((String)loggerOutputType)) {
            try {
                type = LoggerOutputType.valueOf(loggerOutputType.toUpperCase());
            }
            catch (Exception e) {
                this.onInitializationError(String.format("Error: Illegal value '%s' for the SDK Internal Logger type.", loggerOutputType));
                return;
            }
        }
        switch (type) {
            case CONSOLE: {
                this.loggerOutput = new ConsoleLoggerOutput();
                return;
            }
            case FILE: {
                try {
                    this.loggerOutput = new FileLoggerOutput(loggerData);
                }
                catch (Exception e) {
                    this.onInitializationError(String.format("SDK Internal Logger internal error while initializing 'FILE': '%s'.", e.getMessage()));
                }
                return;
            }
        }
    }

    private void onInitializationError(String errorMessage) {
        try {
            this.loggerOutput = null;
            this.loggingLevel = LoggingLevel.OFF;
            new ConsoleLoggerOutput().log(errorMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void log(LoggingLevel requestLevel, String message, Object ... args) {
        if (requestLevel.getValue() >= this.loggingLevel.getValue()) {
            this.loggerOutput.log(InternalLogger.createMessage(requestLevel.toString(), message, args));
        }
    }

    static {
        dateFormatter = new SimpleDateFormat("dd-MM-yyyy h:MM");
    }

    public static enum LoggerOutputType {
        CONSOLE,
        FILE;

    }

    public static enum LoggingLevel {
        ALL(Integer.MIN_VALUE),
        TRACE(10000),
        INFO(20000),
        WARN(30000),
        ERROR(40000),
        OFF(50000);

        private int value;

        private LoggingLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

