/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractWindowsPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.JniPCConnector;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCounterData;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;
import java.util.HashMap;
import java.util.Map;

public final class WindowsPerformanceCounterAsPC
extends AbstractWindowsPerformanceCounter {
    private static final String ID = "JSDK_WindowsPerformanceCounterAsPC";
    private final HashMap<String, WindowsPerformanceCounterData> pcs = new HashMap();

    public WindowsPerformanceCounterAsPC() throws Throwable {
        Preconditions.checkState((boolean)SystemInformation.INSTANCE.isWindows(), (Object)"Must be used under Windows OS.");
        this.register("Processor", "% Processor Time", "_Total");
        this.register("Memory", "Available Bytes", "");
        this.register("Process", "IO Data Bytes/sec", JniPCConnector.translateInstanceName("__SELF__"));
        if (this.pcs.isEmpty()) {
            throw new Exception("Failed to register all built-in Windows performance counters.");
        }
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        for (Map.Entry<String, WindowsPerformanceCounterData> entry : this.pcs.entrySet()) {
            try {
                double value = JniPCConnector.getValueOfPerformanceCounter(entry.getKey());
                if (value < 0.0) {
                    this.reportError(value, entry.getValue().displayName);
                    continue;
                }
                this.send(telemetryClient, value, entry.getValue());
                WindowsPerformanceCounterData pcData = entry.getValue();
                InternalLogger.INSTANCE.trace("Sent performance counter for '%s'(%s, %s, %s): '%s'", pcData.displayName, pcData.categoryName, pcData.counterName, pcData.instanceName, value);
            }
            catch (Throwable e) {
                InternalLogger.INSTANCE.error("Failed to send performance counter for '%s': '%s'", entry.getValue().displayName, e.getMessage());
            }
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    private void send(TelemetryClient telemetryClient, double value, WindowsPerformanceCounterData data) {
        PerformanceCounterTelemetry telemetry = new PerformanceCounterTelemetry(data.categoryName, data.counterName, data.instanceName, value);
        telemetryClient.track(telemetry);
    }

    private void register(String category, String counter, String instance) {
        String key = JniPCConnector.addPerformanceCounter(category, counter, instance);
        if (!Strings.isNullOrEmpty((String)key)) {
            try {
                WindowsPerformanceCounterData data = new WindowsPerformanceCounterData().setCategoryName(category).setCounterName(counter).setInstanceName(instance).setDisplayName(category + " " + counter);
                this.pcs.put(key, data);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }
}

