/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.schemav2;

import com.microsoft.applicationinsights.internal.schemav2.Domain;
import com.microsoft.applicationinsights.telemetry.JsonSerializable;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MessageData
extends Domain
implements JsonSerializable {
    public static final String MESSAGE_ENVELOPE_NAME = "Microsoft.ApplicationInsights.Message";
    public static final String MESSAGE_BASE_TYPE = "Microsoft.ApplicationInsights.MessageData";
    private int ver = 2;
    private String message;
    private SeverityLevel severityLevel = null;
    private ConcurrentMap<String, String> properties;

    public MessageData() {
        this.InitializeFields();
    }

    public int getVer() {
        return this.ver;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        this.message = value;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(SeverityLevel value) {
        this.severityLevel = value;
    }

    public ConcurrentMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(ConcurrentMap<String, String> value) {
        this.properties = value;
    }

    @Override
    protected void serializeContent(JsonTelemetryDataSerializer writer) throws IOException {
        super.serializeContent(writer);
        writer.write("ver", this.ver);
        writer.write("message", this.message);
        if (this.severityLevel != null) {
            writer.write("severityLevel", this.severityLevel.toString());
        }
        writer.write("properties", this.properties);
    }

    @Override
    public String getEnvelopName() {
        return MESSAGE_ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return MESSAGE_BASE_TYPE;
    }

    @Override
    protected void InitializeFields() {
    }
}

