/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.schemav2;

import com.microsoft.applicationinsights.internal.schemav2.DataPointType;
import com.microsoft.applicationinsights.internal.schemav2.DependencyKind;
import com.microsoft.applicationinsights.internal.schemav2.DependencySourceType;
import com.microsoft.applicationinsights.internal.schemav2.Domain;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RemoteDependencyData
extends Domain {
    public static final String REMOTE_ENVELOPE_NAME = "Microsoft.ApplicationInsights.RemoteDependency";
    public static final String REMOTE_BASE_TYPE = "Microsoft.ApplicationInsights.RemoteDependencyData";
    private int ver = 2;
    private String name;
    private String commandName;
    private DataPointType kind = DataPointType.Measurement;
    private Integer count;
    private Double min;
    private Double max;
    private Double stdDev;
    private DependencyKind dependencyKind = DependencyKind.Undefined;
    private Boolean success = true;
    private Boolean async;
    private DependencySourceType dependencySource = DependencySourceType.Undefined;
    private ConcurrentMap<String, String> properties;
    private Duration duration;

    public RemoteDependencyData() {
        this.InitializeFields();
    }

    public int getVer() {
        return this.ver;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public DataPointType getKind() {
        return this.kind;
    }

    public void setKind(DataPointType value) {
        this.kind = value;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer value) {
        this.count = value;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double value) {
        this.min = value;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double value) {
        this.max = value;
    }

    public Double getStdDev() {
        return this.stdDev;
    }

    public void setStdDev(Double value) {
        this.stdDev = value;
    }

    public DependencyKind getDependencyKind() {
        return this.dependencyKind;
    }

    public void setDependencyKind(DependencyKind value) {
        this.dependencyKind = value;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean value) {
        this.success = value;
    }

    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean value) {
        this.async = value;
    }

    public DependencySourceType getDependencySource() {
        return this.dependencySource;
    }

    public void setDependencySource(DependencySourceType value) {
        this.dependencySource = value;
    }

    public ConcurrentMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(ConcurrentMap<String, String> value) {
        this.properties = value;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    @Override
    protected void serializeContent(JsonTelemetryDataSerializer writer) throws IOException {
        super.serializeContent(writer);
        writer.write("ver", this.ver);
        writer.write("name", this.name);
        writer.write("commandName", this.commandName);
        writer.write("kind", this.kind.getValue());
        writer.write("value", this.duration.getTotalMilliseconds());
        writer.write("count", this.count);
        writer.write("min", this.min);
        writer.write("max", this.max);
        writer.write("stdDev", this.stdDev);
        writer.write("dependencyKind", this.dependencyKind.getValue());
        writer.write("success", this.success);
        writer.write("async", this.async);
        writer.write("dependencySource", this.dependencySource.getValue());
        writer.write("properties", this.properties);
    }

    @Override
    public String getEnvelopName() {
        return REMOTE_ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return REMOTE_BASE_TYPE;
    }

    @Override
    protected void InitializeFields() {
    }
}

