/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.system;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.lang.management.ManagementFactory;
import org.apache.commons.lang3.SystemUtils;

public enum SystemInformation {
    INSTANCE;

    private static final String DEFAULT_PROCESS_NAME = "Java_Process";
    private String processId;

    public String getProcessId() {
        this.setProcessId();
        return this.processId;
    }

    public boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public boolean isUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    private synchronized void setProcessId() {
        int i;
        if (!Strings.isNullOrEmpty((String)this.processId)) {
            return;
        }
        String rawName = ManagementFactory.getRuntimeMXBean().getName();
        if (!Strings.isNullOrEmpty((String)rawName) && (i = rawName.indexOf("@")) != -1) {
            String processIdAsString = rawName.substring(0, i);
            try {
                Integer.parseInt(processIdAsString);
                this.processId = processIdAsString;
                return;
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to fetch process id: '%s'", e.getMessage());
            }
        }
        this.processId = DEFAULT_PROCESS_NAME;
    }
}

