/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.internal.schemav2.PageViewData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;
import java.net.URI;
import java.util.concurrent.ConcurrentMap;

public final class PageViewTelemetry
extends BaseTelemetry<PageViewData> {
    private PageViewData data = new PageViewData();

    public PageViewTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public PageViewTelemetry(String pageName) {
        this();
        this.setName(pageName);
    }

    public void setName(String name) {
        this.data.setName(name);
    }

    public String getName() {
        return this.data.getName();
    }

    public URI getUri() {
        URI result = Sanitizer.safeStringToUri(this.data.getUrl());
        if (result == null) {
            this.data.setUrl(null);
        }
        return result;
    }

    public void setUrl(URI url) {
        this.data.setUrl(url == null ? null : url.toString());
    }

    public long getDuration() {
        return this.data.getDuration();
    }

    public void setDuration(long duration) {
        this.data.setDuration(duration);
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    @Override
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
        Sanitizer.sanitizeMeasurements(this.getMetrics());
        Sanitizer.sanitizeUri(this.data.getUrl());
    }

    @Override
    protected PageViewData getData() {
        return this.data;
    }
}

