/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.internal.channel.common.ApacheSender;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

final class ApacheSender43
implements ApacheSender {
    private final CloseableHttpClient httpClient;

    public ApacheSender43() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    @Override
    public HttpResponse sendPostRequest(HttpPost post) throws IOException {
        return this.httpClient.execute((HttpUriRequest)post);
    }

    @Override
    public void dispose(HttpResponse response) {
        try {
            if (response != null) {
                ((CloseableHttpResponse)response).close();
            }
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to send or failed to close response, exception: %s", e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to close http client, exception: %s", e.getMessage());
        }
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void enhanceRequest(HttpPost request) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setConnectTimeout(60000).setSocketTimeout(60000).build();
        request.setConfig(requestConfig);
    }
}

