/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.simplehttp;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

final class SimpleHttpChannel
implements TelemetryChannel {
    private static final String DEFAULT_SERVER_URI = "https://dc.services.visualstudio.com/v2/track";
    private boolean developerMode = false;

    @Override
    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    @Override
    public void setDeveloperMode(boolean value) {
        this.developerMode = value;
    }

    public SimpleHttpChannel(Map<String, String> namesAndValues) {
    }

    @Override
    public void send(Telemetry item) {
        try {
            StringWriter writer = new StringWriter();
            item.serialize(new JsonTelemetryDataSerializer(writer));
            String payload = writer.toString();
            if (this.developerMode) {
                InternalLogger.INSTANCE.trace("SimpleHttpChannel, payload: %s", payload);
            }
            HttpPost request = new HttpPost(DEFAULT_SERVER_URI);
            StringEntity body = new StringEntity(payload, ContentType.create((String)"application/x-json-stream"));
            request.setEntity((HttpEntity)body);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)request);
                HttpEntity respEntity = response.getEntity();
                if (respEntity != null) {
                    respEntity.getContent().close();
                }
                if (this.developerMode) {
                    InternalLogger.INSTANCE.trace("SimpleHttpChannel, response: %s", response.getStatusLine());
                }
            }
            catch (IOException ioe) {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException ioeIn) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
    }

    @Override
    public void flush() {
    }
}

