/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.internal.perfcounter.UnixParsingState;

final class UnixProcessIOtParser {
    private static final String READ_BYTES_PART = "read_bytes:";
    private static final String WRITE_BYTES_PART = "write_bytes:";
    UnixParsingState state = new UnixParsingState(2);
    boolean readBytesDone = false;
    boolean writeBytesDone = false;

    UnixProcessIOtParser() {
    }

    boolean done() {
        return this.state.doneCounter == 0;
    }

    double getValue() {
        return this.state.returnValue;
    }

    void process(String line) {
        if (!this.readBytesDone && this.parseValue(line, READ_BYTES_PART)) {
            this.readBytesDone = true;
            return;
        }
        if (!this.writeBytesDone && this.parseValue(line, WRITE_BYTES_PART)) {
            this.writeBytesDone = true;
            return;
        }
    }

    private boolean parseValue(String line, String part) {
        int index = line.indexOf(part);
        if (index != -1) {
            String doubleValueAsString = line.substring(index + part.length());
            try {
                this.state.returnValue += Double.valueOf(doubleValueAsString.trim()).doubleValue();
                --this.state.doneCounter;
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }
}

