/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.schemav2;

import com.microsoft.applicationinsights.internal.schemav2.DataPoint;
import com.microsoft.applicationinsights.internal.schemav2.Domain;
import com.microsoft.applicationinsights.telemetry.JsonSerializable;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MetricData
extends Domain
implements JsonSerializable {
    public static final String METRIC_ENVELOPE_NAME = "Microsoft.ApplicationInsights.Metric";
    public static final String METRIC_BASE_TYPE = "Microsoft.ApplicationInsights.MetricData";
    private int ver = 2;
    private List<DataPoint> metrics;
    private ConcurrentMap<String, String> properties;

    public MetricData() {
        this.InitializeFields();
    }

    public int getVer() {
        return this.ver;
    }

    public List<DataPoint> getMetrics() {
        if (this.metrics == null) {
            this.metrics = new ArrayList<DataPoint>();
        }
        return this.metrics;
    }

    public void setMetrics(List<DataPoint> value) {
        this.metrics = value;
    }

    public ConcurrentMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(ConcurrentMap<String, String> value) {
        this.properties = value;
    }

    @Override
    protected void serializeContent(JsonTelemetryDataSerializer writer) throws IOException {
        super.serializeContent(writer);
        writer.write("ver", this.ver);
        writer.write("metrics", this.metrics);
        writer.write("properties", this.properties);
    }

    @Override
    public String getEnvelopName() {
        return METRIC_ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return METRIC_BASE_TYPE;
    }

    @Override
    protected void InitializeFields() {
    }
}

