/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.agent.internal.coresync.AgentNotificationsHandler;
import com.microsoft.applicationinsights.agent.internal.coresync.InstrumentedClassType;
import com.microsoft.applicationinsights.agent.internal.coresync.impl.ImplementationsCoordinator;
import com.microsoft.applicationinsights.internal.agent.ArgsFormatter;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.schemav2.DependencyKind;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;

final class CoreAgentNotificationsHandler
implements AgentNotificationsHandler {
    private final ThreadLocalCleaner cleaner = new ThreadLocalCleaner(){

        @Override
        public void clean() {
            CoreAgentNotificationsHandler.this.threadDataThreadLocal.remove();
        }
    };
    private ThreadLocalData threadDataThreadLocal = new ThreadLocalData();
    private TelemetryClient telemetryClient = new TelemetryClient();
    private final String name;

    public ThreadLocalCleaner getCleaner() {
        return this.cleaner;
    }

    public CoreAgentNotificationsHandler(String name) {
        this.name = name;
    }

    public void exceptionCaught(String classAndMethodNames, Throwable throwable) {
        try {
            if (throwable instanceof Exception) {
                this.telemetryClient.trackException((Exception)throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public void httpMethodStarted(String classAndMethodNames, String url) {
        this.startMethod(InstrumentedClassType.HTTP, this.name, url);
    }

    public void sqlStatementExecuteQueryPossibleQueryPlan(String name, Statement statement, String sqlStatement) {
        this.startSqlMethod(statement, sqlStatement, null);
    }

    public void preparedStatementMethodStarted(String classAndMethodNames, PreparedStatement statement, String sqlStatement, Object[] args) {
        this.startSqlMethod(statement, sqlStatement, args);
    }

    public void sqlStatementMethodStarted(String name, Statement statement, String sqlStatement) {
        this.startSqlMethod(statement, sqlStatement, null);
    }

    public void preparedStatementExecuteBatchMethodStarted(String classAndMethodNames, PreparedStatement statement, String sqlStatement, int batchCounter) {
        String batchData = String.format("Batch of %d", batchCounter);
        this.startSqlMethod(statement, sqlStatement, new Object[]{batchData});
    }

    public String getName() {
        return this.name;
    }

    public void methodStarted(String name) {
        this.startMethod(InstrumentedClassType.OTHER, name, new String[0]);
    }

    public void methodFinished(String name, Throwable throwable) {
        if (!this.finalizeMethod(null, throwable)) {
            InternalLogger.INSTANCE.error("Agent has detected a 'Finish' method '%s' with exception '%s' event without a 'Start'", name, throwable == null ? "unknown" : throwable.getClass().getName());
        }
    }

    public void methodFinished(String name) {
        if (!this.finalizeMethod(null, null)) {
            InternalLogger.INSTANCE.error("Agent has detected a 'Finish' method ('%s') event without a 'Start'", name);
        }
    }

    public void methodFinished(String classAndMethodNames, long deltaInNS, Object[] args, Throwable throwable) {
        long durationInMS = CoreAgentNotificationsHandler.nanoToMilliseconds(deltaInNS);
        Duration duration = new Duration(durationInMS);
        RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(classAndMethodNames, null, duration, throwable == null);
        telemetry.setDependencyKind(DependencyKind.Other);
        if (args != null) {
            String argsAsString = new ArgsFormatter().format(args);
            telemetry.getContext().getProperties().put("Args", argsAsString);
        }
        InternalLogger.INSTANCE.trace("Sending RDD event for '%s', duration=%s ms", classAndMethodNames, durationInMS);
        this.telemetryClient.track(telemetry);
        if (throwable != null) {
            ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
            this.telemetryClient.track(exceptionTelemetry);
        }
    }

    private void startSqlMethod(Statement statement, String sqlStatement, Object[] additionalArgs) {
        try {
            Connection connection = null;
            String url = null;
            if (statement != null) {
                try {
                    DatabaseMetaData metaData;
                    connection = statement.getConnection();
                    if (connection != null && (metaData = connection.getMetaData()) != null) {
                        url = metaData.getURL();
                    }
                }
                catch (Throwable t) {
                    url = "jdbc:Unknown DB URL (failed to fetch from connection)";
                }
            }
            Object[] sqlMetaData = additionalArgs == null ? new Object[]{url, sqlStatement, connection} : new Object[]{url, sqlStatement, connection, additionalArgs};
            this.startSqlMethod(InstrumentedClassType.SQL, this.name, sqlMetaData);
            ThreadData threadData = (ThreadData)this.threadDataThreadLocal.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startMethod(InstrumentedClassType type, String name, String ... arguments) {
        long start = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        MethodData methodData = new MethodData();
        methodData.interval = start;
        methodData.type = type;
        methodData.arguments = arguments;
        methodData.name = name;
        localData.methods.addFirst(methodData);
    }

    private void startSqlMethod(InstrumentedClassType type, String name, Object ... arguments) {
        long start = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        MethodData methodData = new MethodData();
        methodData.interval = start;
        methodData.type = type;
        methodData.arguments = arguments;
        methodData.name = name;
        localData.methods.addFirst(methodData);
    }

    private boolean finalizeMethod(Object result, Throwable throwable) {
        long finish = System.nanoTime();
        ThreadData localData = (ThreadData)this.threadDataThreadLocal.get();
        if (localData.methods == null || localData.methods.isEmpty()) {
            return false;
        }
        MethodData methodData = localData.methods.removeFirst();
        if (methodData == null) {
            return true;
        }
        methodData.interval = finish - methodData.interval;
        methodData.result = result;
        this.report(methodData, throwable);
        return true;
    }

    private void report(MethodData methodData, Throwable throwable) {
        switch (methodData.type) {
            case SQL: {
                this.sendSQLTelemetry(methodData, throwable);
                break;
            }
            case HTTP: {
                this.sendHTTPTelemetry(methodData, throwable);
                break;
            }
            default: {
                this.sendInstrumentationTelemetry(methodData, throwable);
            }
        }
    }

    private void sendInstrumentationTelemetry(MethodData methodData, Throwable throwable) {
        Duration duration = new Duration(CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval));
        RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(methodData.name, null, duration, throwable == null);
        telemetry.setDependencyKind(DependencyKind.Other);
        InternalLogger.INSTANCE.trace("Sending RDD event for '%s'", methodData.name);
        this.telemetryClient.track(telemetry);
        if (throwable != null) {
            ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
            this.telemetryClient.track(exceptionTelemetry);
        }
    }

    private void sendHTTPTelemetry(MethodData methodData, Throwable throwable) {
        if (methodData.arguments != null && methodData.arguments.length == 1) {
            String url = methodData.arguments[0].toString();
            long durationInMilliSeconds = CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval);
            Duration duration = new Duration(durationInMilliSeconds);
            InternalLogger.INSTANCE.trace("Sending HTTP RDD event, URL: '%s', duration=%s ms", url, durationInMilliSeconds);
            RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(url, null, duration, throwable == null);
            telemetry.setDependencyKind(DependencyKind.Http);
            this.telemetryClient.trackDependency(telemetry);
            if (throwable != null) {
                ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
                this.telemetryClient.track(exceptionTelemetry);
            }
        }
    }

    private void sendSQLTelemetry(MethodData methodData, Throwable throwable) {
        if (methodData.arguments != null && methodData.arguments.length >= 3 && methodData.arguments[1] != null) {
            try {
                String dependencyName = null;
                if (methodData.arguments[0] != null) {
                    dependencyName = methodData.arguments[0].toString();
                }
                String commandName = null;
                if (methodData.arguments[1] == null) {
                    return;
                }
                commandName = methodData.arguments[1].toString();
                long durationInMilliSeconds = CoreAgentNotificationsHandler.nanoToMilliseconds(methodData.interval);
                Duration duration = new Duration(durationInMilliSeconds);
                RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry(dependencyName, commandName, duration, throwable == null);
                telemetry.setDependencyKind(DependencyKind.SQL);
                StringBuilder sb = null;
                if (methodData.arguments.length > 3) {
                    sb = this.formatAdditionalSqlArguments(methodData);
                    if (sb != null) {
                        telemetry.getContext().getProperties().put("Args", sb.toString());
                    }
                } else if (durationInMilliSeconds > ImplementationsCoordinator.INSTANCE.getQueryPlanThresholdInMS() && (sb = this.fetchExplainQuery(commandName, methodData.arguments[2])) != null) {
                    telemetry.getContext().getProperties().put("Query Plan", sb.toString());
                }
                InternalLogger.INSTANCE.trace("Sending Sql RDD event for '%s', command: '%s', duration=%s ms", dependencyName, commandName, durationInMilliSeconds);
                this.telemetryClient.track(telemetry);
                if (throwable != null) {
                    InternalLogger.INSTANCE.trace("Sending Sql exception", new Object[0]);
                    ExceptionTelemetry exceptionTelemetry = new ExceptionTelemetry(throwable);
                    this.telemetryClient.track(exceptionTelemetry);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static long nanoToMilliseconds(long nanoSeconds) {
        return nanoSeconds / 1000000L;
    }

    private StringBuilder formatAdditionalSqlArguments(MethodData methodData) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(" [");
            Object[] args = (Object[])methodData.arguments[3];
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    if (arg == null) {
                        sb.append("null,");
                        continue;
                    }
                    sb.append(arg.toString());
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(']');
            return sb;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder fetchExplainQuery(String commandName, Object object) {
        StringBuilder explainSB = null;
        Statement explain = null;
        ResultSet rs = null;
        try {
            if (commandName.startsWith("SELECT ")) {
                Connection connection = (Connection)object;
                if (connection == null) {
                    StringBuilder stringBuilder = explainSB;
                    return stringBuilder;
                }
                explain = connection.createStatement();
                rs = explain.executeQuery("EXPLAIN " + commandName);
                explainSB = new StringBuilder();
                while (rs.next()) {
                    explainSB.append('[');
                    int columns = rs.getMetaData().getColumnCount();
                    if (columns == 1) {
                        explainSB.append(rs.getString(1));
                    } else {
                        for (int i1 = 1; i1 < rs.getMetaData().getColumnCount(); ++i1) {
                            explainSB.append(rs.getMetaData().getColumnName(i1));
                            explainSB.append(':');
                            Object obj = rs.getObject(i1);
                            explainSB.append(obj == null ? "" : obj.toString());
                            explainSB.append(',');
                        }
                        explainSB.deleteCharAt(explainSB.length() - 1);
                    }
                    explainSB.append("],");
                }
                explainSB.deleteCharAt(explainSB.length() - 1);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (explain != null) {
                try {
                    explain.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return explainSB;
    }

    static final class ThreadLocalData
    extends ThreadLocal<ThreadData> {
        private ThreadData threadData;

        ThreadLocalData() {
        }

        @Override
        protected ThreadData initialValue() {
            this.threadData = new ThreadData();
            return this.threadData;
        }
    }

    private static class ThreadData {
        public final LinkedList<MethodData> methods = new LinkedList();

        private ThreadData() {
        }
    }

    private static class MethodData {
        public String name;
        public Object[] arguments;
        public long interval;
        public InstrumentedClassType type;
        public Object result;

        private MethodData() {
        }
    }
}

