/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TransmissionDispatcher;
import com.microsoft.applicationinsights.internal.channel.TransmissionOutput;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import java.util.concurrent.TimeUnit;

public final class NonBlockingDispatcher
implements TransmissionDispatcher {
    private final TransmissionOutput[] transmissionOutputs;

    public NonBlockingDispatcher(TransmissionOutput[] transmissionOutputs) {
        Preconditions.checkNotNull((Object)transmissionOutputs, (Object)"transmissionOutputs should be non-null value");
        Preconditions.checkArgument((transmissionOutputs.length > 0 ? 1 : 0) != 0, (Object)"There should be at least one TransmissionOutput");
        this.transmissionOutputs = transmissionOutputs;
    }

    @Override
    public void dispatch(Transmission transmission) {
        Preconditions.checkNotNull((Object)transmission, (Object)"transmission should be non-null value");
        for (TransmissionOutput output : this.transmissionOutputs) {
            if (!output.send(transmission)) continue;
            return;
        }
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        for (TransmissionOutput output : this.transmissionOutputs) {
            output.stop(timeout, timeUnit);
        }
    }
}

