/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.internal.config.AppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.ApplicationInsightsXmlConfiguration;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

class JaxbAppInsightsConfigurationBuilder
implements AppInsightsConfigurationBuilder {
    JaxbAppInsightsConfigurationBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationInsightsXmlConfiguration build(InputStream resourceFile) {
        if (resourceFile == null) {
            return null;
        }
        try {
            ApplicationInsightsXmlConfiguration applicationInsights;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationInsightsXmlConfiguration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ApplicationInsightsXmlConfiguration applicationInsightsXmlConfiguration = applicationInsights = (ApplicationInsightsXmlConfiguration)unmarshaller.unmarshal(resourceFile);
            return applicationInsightsXmlConfiguration;
        }
        catch (JAXBException e) {
            if (e.getCause() != null) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to parse configuration file: '%s'", e.getCause().getMessage());
            } else {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to parse configuration file: '%s'", e.getMessage());
            }
        }
        finally {
            try {
                resourceFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

