/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.jmx;

import com.microsoft.applicationinsights.internal.jmx.JmxAttributeData;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularDataSupport;

public class JmxDataFetcher {
    private static final String COMPOSITE_ATTRIBUTE_TYPE = "COMPOSITE";
    private static final String TABULAR_ATTRIBUTE_TYPE = "TABULAR";

    public static Map<String, Collection<Object>> fetch(String objectName, Collection<JmxAttributeData> attributes) throws Exception {
        HashMap<String, Collection<Object>> result = new HashMap<String, Collection<Object>>();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objects = server.queryNames(new ObjectName(objectName), null);
        if (objects.isEmpty()) {
            String errorMsg = String.format("Cannot find object name '%s'", objectName);
            throw new IllegalArgumentException(errorMsg);
        }
        for (JmxAttributeData attribute : attributes) {
            try {
                Collection<Object> resultForAttribute = JmxDataFetcher.fetch(server, objects, attribute.name, attribute.type);
                result.put(attribute.displayName, resultForAttribute);
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to fetch JMX object '%s' with attribute '%s': '%s'", objectName, attribute.name, e.getMessage());
                throw e;
            }
        }
        return result;
    }

    private static Collection<Object> fetch(MBeanServer server, Set<ObjectName> objects, String attributeName, String attributeType) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        String attr = attributeName;
        String[] inners = null;
        AttributeType innerAttributeType = AttributeType.REGULAR;
        if (COMPOSITE_ATTRIBUTE_TYPE.equals(attributeType)) {
            innerAttributeType = AttributeType.COMPOSITE;
        } else if (TABULAR_ATTRIBUTE_TYPE.equals(attributeType)) {
            innerAttributeType = AttributeType.TABULAR;
        }
        if (innerAttributeType != AttributeType.REGULAR) {
            inners = attributeName.split("\\.");
        }
        for (ObjectName object : objects) {
            Object obj;
            if (innerAttributeType != AttributeType.REGULAR) {
                obj = server.getAttribute(object, inners[0]);
                CompositeDataSupport compositeData = null;
                if (innerAttributeType == AttributeType.TABULAR) {
                    TabularDataSupport tabularData = (TabularDataSupport)obj;
                    compositeData = (CompositeDataSupport)tabularData.get(inners[1]);
                    obj = compositeData.get(inners[2]);
                } else {
                    compositeData = (CompositeDataSupport)obj;
                    obj = compositeData.get(inners[1]);
                }
            } else {
                obj = server.getAttribute(object, attr);
            }
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    private JmxDataFetcher() {
    }

    static enum AttributeType {
        TABULAR,
        COMPOSITE,
        REGULAR;

    }
}

