/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.perfcounter.ProcessCpuPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.ProcessMemoryPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.UnixProcessIOPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.UnixTotalCpuPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.UnixTotalMemoryPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCounterAsMetric;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCounterAsPC;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCounterData;
import com.microsoft.applicationinsights.internal.perfcounter.WindowsPerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

final class ProcessBuiltInPerformanceCountersFactory
implements PerformanceCountersFactory,
WindowsPerformanceCountersFactory {
    private Iterable<WindowsPerformanceCounterData> windowsPCsData;

    ProcessBuiltInPerformanceCountersFactory() {
    }

    @Override
    public Collection<PerformanceCounter> getPerformanceCounters() {
        try {
            if (SystemInformation.INSTANCE.isWindows()) {
                return this.getWindowsPerformanceCounters();
            }
            if (SystemInformation.INSTANCE.isUnix()) {
                return this.getUnixPerformanceCounters();
            }
            InternalLogger.INSTANCE.error("Unknown OS, performance counters are not created.", new Object[0]);
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.error("Error while creating performance counters: '%s'", t.getMessage());
        }
        return Collections.emptyList();
    }

    private ArrayList<PerformanceCounter> getMutualPerformanceCounters() {
        ArrayList<PerformanceCounter> performanceCounters = new ArrayList<PerformanceCounter>();
        performanceCounters.add(new ProcessMemoryPerformanceCounter());
        performanceCounters.add(new ProcessCpuPerformanceCounter());
        return performanceCounters;
    }

    private Collection<PerformanceCounter> getUnixPerformanceCounters() {
        ArrayList<PerformanceCounter> performanceCounters = this.getMutualPerformanceCounters();
        performanceCounters.add(new UnixProcessIOPerformanceCounter());
        performanceCounters.add(new UnixTotalCpuPerformanceCounter());
        performanceCounters.add(new UnixTotalMemoryPerformanceCounter());
        return performanceCounters;
    }

    private Collection<PerformanceCounter> getWindowsPerformanceCounters() {
        ArrayList<PerformanceCounter> performanceCounters = this.getMutualPerformanceCounters();
        try {
            if (this.windowsPCsData != null) {
                WindowsPerformanceCounterAsMetric pcWindowsMetric = new WindowsPerformanceCounterAsMetric(this.windowsPCsData);
                performanceCounters.add(pcWindowsMetric);
                this.windowsPCsData = null;
            }
        }
        catch (Throwable e) {
            InternalLogger.INSTANCE.error("Failed to create WindowsPerformanceCounterAsMetric: '%s'", e.getMessage());
        }
        try {
            WindowsPerformanceCounterAsPC pcWindowsPCs = new WindowsPerformanceCounterAsPC();
            performanceCounters.add(pcWindowsPCs);
        }
        catch (Throwable e) {
            InternalLogger.INSTANCE.error("Failed to create WindowsPerformanceCounterAsPC: '%s'", e.getMessage());
        }
        return performanceCounters;
    }

    @Override
    public void setWindowsPCs(Iterable<WindowsPerformanceCounterData> windowsPCsData) {
        this.windowsPCsData = windowsPCsData;
    }
}

