/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.channel.TelemetrySerializer;
import com.microsoft.applicationinsights.internal.channel.TransmissionDispatcher;
import com.microsoft.applicationinsights.internal.channel.TransmissionsLoader;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.Collection;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class TransmitterImpl
implements TelemetriesTransmitter {
    private static final int MAX_PENDING_SCHEDULE_REQUESTS = 16384;
    private final TransmissionDispatcher transmissionDispatcher;
    private final TelemetrySerializer serializer;
    private final ScheduledThreadPoolExecutor threadPool;
    private final TransmissionsLoader transmissionsLoader;
    private final Semaphore semaphore;

    public TransmitterImpl(TransmissionDispatcher transmissionDispatcher, TelemetrySerializer serializer, TransmissionsLoader transmissionsLoader) {
        Preconditions.checkNotNull((Object)transmissionDispatcher, (Object)"transmissionDispatcher must be non-null value");
        Preconditions.checkNotNull((Object)serializer, (Object)"serializer must be non-null value");
        Preconditions.checkNotNull((Object)transmissionsLoader, (Object)"transmissionsLoader must be non-null value");
        this.transmissionDispatcher = transmissionDispatcher;
        this.serializer = serializer;
        this.semaphore = new Semaphore(16384);
        this.threadPool = new ScheduledThreadPoolExecutor(2);
        this.threadPool.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.transmissionsLoader = transmissionsLoader;
        this.transmissionsLoader.load(false);
    }

    @Override
    public boolean scheduleSend(TelemetriesTransmitter.TelemetriesFetcher telemetriesFetcher, long value, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)telemetriesFetcher, (Object)"telemetriesFetcher should be non-null value");
        if (!this.semaphore.tryAcquire()) {
            return false;
        }
        try {
            final ScheduledSendHandler command = new ScheduledSendHandler(this.transmissionDispatcher, telemetriesFetcher, this.serializer);
            this.threadPool.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        TransmitterImpl.this.semaphore.release();
                        command.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                    }
                }
            }, value, timeUnit);
            return true;
        }
        catch (Exception e) {
            this.semaphore.release();
        }
        catch (Throwable t) {
            this.semaphore.release();
        }
        return true;
    }

    @Override
    public boolean sendNow(Collection<String> telemetries) {
        Preconditions.checkNotNull(telemetries, (Object)"telemetries should be non-null value");
        if (!this.semaphore.tryAcquire()) {
            return false;
        }
        final SendNowHandler command = new SendNowHandler(this.transmissionDispatcher, this.serializer, telemetries);
        try {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        TransmitterImpl.this.semaphore.release();
                        command.run();
                    }
                    catch (Exception exception) {
                    }
                    catch (Throwable throwable) {
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            this.semaphore.release();
        }
        catch (Throwable t) {
            this.semaphore.release();
        }
        return false;
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        this.transmissionsLoader.stop(timeout, timeUnit);
        ThreadPoolUtils.stop(this.threadPool, timeout, timeUnit);
        this.transmissionDispatcher.stop(timeout, timeUnit);
    }

    private static final class SendNowHandler
    extends SendHandler
    implements Runnable {
        private final Collection<String> telemetries;

        public SendNowHandler(TransmissionDispatcher transmissionDispatcher, TelemetrySerializer serializer, Collection<String> telemetries) {
            super(transmissionDispatcher, serializer);
            Preconditions.checkNotNull(telemetries, (Object)"telemetries should be non-null value");
            this.telemetries = telemetries;
        }

        @Override
        public void run() {
            this.dispatch(this.telemetries);
        }
    }

    private static final class ScheduledSendHandler
    extends SendHandler
    implements Runnable {
        private final TelemetriesTransmitter.TelemetriesFetcher telemetriesFetcher;

        public ScheduledSendHandler(TransmissionDispatcher transmissionDispatcher, TelemetriesTransmitter.TelemetriesFetcher telemetriesFetcher, TelemetrySerializer serializer) {
            super(transmissionDispatcher, serializer);
            Preconditions.checkNotNull((Object)telemetriesFetcher, (Object)"telemetriesFetcher should be a non-null value");
            this.telemetriesFetcher = telemetriesFetcher;
        }

        @Override
        public void run() {
            Collection<String> telemetriesToSend = this.telemetriesFetcher.fetch();
            this.dispatch(telemetriesToSend);
        }
    }

    private static abstract class SendHandler {
        protected final TransmissionDispatcher transmissionDispatcher;
        protected final TelemetrySerializer serializer;

        protected SendHandler(TransmissionDispatcher transmissionDispatcher, TelemetrySerializer serializer) {
            Preconditions.checkNotNull((Object)transmissionDispatcher, (Object)"transmissionDispatcher should be a non-null value");
            Preconditions.checkNotNull((Object)serializer, (Object)"serializer should be a non-null value");
            this.transmissionDispatcher = transmissionDispatcher;
            this.serializer = serializer;
        }

        protected void dispatch(Collection<String> telemetries) {
            if (telemetries.isEmpty()) {
                return;
            }
            Optional<Transmission> transmission = this.serializer.serialize(telemetries);
            if (!transmission.isPresent()) {
                return;
            }
            this.transmissionDispatcher.dispatch((Transmission)transmission.get());
        }
    }
}

