/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.DependencyKind;
import com.microsoft.applicationinsights.internal.schemav2.DependencySourceType;
import com.microsoft.applicationinsights.internal.schemav2.RemoteDependencyData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;
import com.microsoft.applicationinsights.telemetry.Duration;

public final class RemoteDependencyTelemetry
extends BaseTelemetry<RemoteDependencyData> {
    private final RemoteDependencyData data = new RemoteDependencyData();

    public RemoteDependencyTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public RemoteDependencyTelemetry(String name) {
        this();
        this.setName(name);
    }

    public RemoteDependencyTelemetry(String dependencyName, String commandName, Duration duration, boolean success) {
        this(dependencyName);
        this.data.setCommandName(commandName);
        this.data.setDuration(duration);
        this.data.setSuccess(success);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
    }

    public String getCommandName() {
        return this.data.getCommandName();
    }

    public void setCommandName(String commandName) {
        this.data.setCommandName(commandName);
    }

    public Integer getCount() {
        return this.data.getCount();
    }

    public void setCount(Integer value) {
        this.data.setCount(value);
    }

    public Double getMin() {
        return this.data.getMin();
    }

    public void setMin(Double value) {
        this.data.setMin(value);
    }

    public Double getMax() {
        return this.data.getMax();
    }

    public void setMax(Double value) {
        this.data.setMax(value);
    }

    public Double getStdDev() {
        return this.data.getStdDev();
    }

    public void setStdDev(Double value) {
        this.data.setStdDev(value);
    }

    public DependencyKind getDependencyKind() {
        return this.data.getDependencyKind();
    }

    public void setDependencyKind(DependencyKind value) {
        this.data.setDependencyKind(value);
    }

    public boolean getSuccess() {
        return this.data.getSuccess();
    }

    public void setSuccess(boolean value) {
        this.data.setSuccess(value);
    }

    public Boolean getAsync() {
        return this.data.getAsync();
    }

    public void setAsync(Boolean value) {
        this.data.setAsync(value);
    }

    public DependencySourceType getDependencySource() {
        return this.data.getDependencySource();
    }

    public void setDependencySource(DependencySourceType value) {
        this.data.setDependencySource(value);
    }

    public Duration getDuration() {
        return this.data.getDuration();
    }

    public void setDuration(Duration duration) {
        this.data.setDuration(duration);
    }

    @Override
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
    }

    @Override
    protected RemoteDependencyData getData() {
        return this.data;
    }
}

