/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class SenderThreadLocalBackOffData {
    private final ReentrantLock lock;
    private final Condition backOffCondition;
    private int currentBackOffIndex;
    private boolean instanceIsActive;
    private final long addMilliseconds;
    private final long[] backOffTimeoutsInMillis;

    public SenderThreadLocalBackOffData(long[] backOffTimeoutsInMillis, long addMilliseconds) {
        Preconditions.checkNotNull((Object)backOffTimeoutsInMillis, (Object)"backOffTimeoutsInSeconds must be not null");
        Preconditions.checkArgument((backOffTimeoutsInMillis.length > 0 ? 1 : 0) != 0, (Object)"backOffTimeoutsInSeconds must not be empty");
        Preconditions.checkArgument((addMilliseconds >= 0L ? 1 : 0) != 0, (Object)"addSeconds must not be >= 0");
        this.currentBackOffIndex = -1;
        this.instanceIsActive = true;
        this.lock = new ReentrantLock();
        this.backOffCondition = this.lock.newCondition();
        this.backOffTimeoutsInMillis = backOffTimeoutsInMillis;
        this.addMilliseconds = addMilliseconds;
    }

    public boolean isTryingToSend() {
        return this.currentBackOffIndex != -1;
    }

    public void onDoneSending() {
        this.currentBackOffIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backOff() {
        try {
            this.lock.lock();
            ++this.currentBackOffIndex;
            if (this.currentBackOffIndex == this.backOffTimeoutsInMillis.length) {
                this.currentBackOffIndex = -1;
                boolean bl = false;
                return bl;
            }
            if (!this.instanceIsActive) {
                boolean bl = false;
                return bl;
            }
            long millisecondsToWait = this.backOffTimeoutsInMillis[this.currentBackOffIndex];
            if (millisecondsToWait > 5000L) {
                millisecondsToWait += this.addMilliseconds;
            }
            this.backOffCondition.await(millisecondsToWait, TimeUnit.MILLISECONDS);
            boolean bl = this.instanceIsActive;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        try {
            this.lock.lock();
            this.instanceIsActive = false;
            this.backOffCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

