/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.primitives.Longs;
import com.microsoft.applicationinsights.internal.channel.common.BackOffTimesPolicy;
import com.microsoft.applicationinsights.internal.channel.common.ExponentialBackOffTimesPolicy;
import com.microsoft.applicationinsights.internal.channel.common.SenderThreadLocalBackOffData;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

final class SenderThreadsBackOffManager
extends ThreadLocal<SenderThreadLocalBackOffData> {
    private long[] backOffTimeoutsInMilliseconds = null;
    private final ArrayList<SenderThreadLocalBackOffData> allSendersData;
    private final AtomicInteger threadsSecondsDifference = new AtomicInteger(-1);
    private SenderThreadLocalBackOffData senderThreadLocalData;
    private boolean stopped;

    public SenderThreadsBackOffManager(BackOffTimesPolicy backOffTimesContainer) {
        this.allSendersData = new ArrayList();
        this.initializeBackOffTimeouts(backOffTimesContainer);
    }

    public void onDoneSending() {
        SenderThreadLocalBackOffData currentThreadData = (SenderThreadLocalBackOffData)this.get();
        currentThreadData.onDoneSending();
    }

    public boolean backOffCurrentSenderThread() {
        SenderThreadLocalBackOffData currentThreadData = (SenderThreadLocalBackOffData)this.get();
        return currentThreadData.backOff();
    }

    public synchronized void stopAllSendersBackOffActivities() {
        for (SenderThreadLocalBackOffData sender : this.allSendersData) {
            sender.stop();
        }
        this.stopped = true;
    }

    @Override
    protected SenderThreadLocalBackOffData initialValue() {
        int addSeconds = this.threadsSecondsDifference.incrementAndGet();
        this.senderThreadLocalData = new SenderThreadLocalBackOffData(this.backOffTimeoutsInMilliseconds, addSeconds * 1000);
        this.registerSenderData(this.senderThreadLocalData);
        return this.senderThreadLocalData;
    }

    private synchronized void registerSenderData(SenderThreadLocalBackOffData senderData) {
        if (this.stopped) {
            senderData.stop();
        }
        this.allSendersData.add(senderData);
    }

    private synchronized void initializeBackOffTimeouts(BackOffTimesPolicy container) {
        if (this.backOffTimeoutsInMilliseconds != null) {
            return;
        }
        if (container == null) {
            this.backOffTimeoutsInMilliseconds = new ExponentialBackOffTimesPolicy().getBackOffTimeoutsInMillis();
            InternalLogger.INSTANCE.trace("No BackOffTimesContainer, using default values.", new Object[0]);
            return;
        }
        long[] injectedBackOffTimeoutsInSeconds = container.getBackOffTimeoutsInMillis();
        ArrayList<Long> validBackOffTimeoutsInSeconds = new ArrayList<Long>();
        if (injectedBackOffTimeoutsInSeconds != null) {
            for (long backOffValue : injectedBackOffTimeoutsInSeconds) {
                if (backOffValue <= 0L) continue;
                validBackOffTimeoutsInSeconds.add(backOffValue);
            }
        }
        if (validBackOffTimeoutsInSeconds.isEmpty()) {
            this.backOffTimeoutsInMilliseconds = new ExponentialBackOffTimesPolicy().getBackOffTimeoutsInMillis();
            InternalLogger.INSTANCE.trace("BackOff timeouts are not supplied or not valid, using default values.", new Object[0]);
            return;
        }
        this.backOffTimeoutsInMilliseconds = Longs.toArray(validBackOffTimeoutsInSeconds);
    }
}

