/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractPerformanceCounter;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

final class ProcessCpuPerformanceCounter
extends AbstractPerformanceCounter {
    private final int numberOfCpus;
    private long prevUpTime;
    private long prevProcessCpuTime;

    public ProcessCpuPerformanceCounter() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.numberOfCpus = operatingSystemMXBean.getAvailableProcessors();
    }

    @Override
    public String getId() {
        return "JSDK_ProcessCpuPerformanceCounter";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        double processCpuUsage = this.getProcessCpuUsage();
        InternalLogger.INSTANCE.trace("Performance Counter: %s %s: %s", ProcessCpuPerformanceCounter.getProcessCategoryName(), "% Processor Time", processCpuUsage);
        PerformanceCounterTelemetry telemetry = new PerformanceCounterTelemetry(ProcessCpuPerformanceCounter.getProcessCategoryName(), "% Processor Time", SystemInformation.INSTANCE.getProcessId(), processCpuUsage);
        telemetryClient.track(telemetry);
    }

    private double getProcessCpuUsage() {
        double processCpuUsage;
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            long upTime = runtimeMXBean.getUptime();
            long processCpuTime = operatingSystemMXBean.getProcessCpuTime();
            if (this.prevUpTime > 0L && upTime > this.prevUpTime) {
                long elapsedCpu = processCpuTime - this.prevProcessCpuTime;
                long elapsedTime = upTime - this.prevUpTime;
                processCpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)this.numberOfCpus));
            } else {
                processCpuUsage = -1.0;
            }
            this.prevUpTime = upTime;
            this.prevProcessCpuTime = processCpuTime;
        }
        catch (Exception e) {
            processCpuUsage = -1.0;
        }
        return processCpuUsage;
    }
}

