/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.schemav2;

import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.schemav2.Domain;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EventData
extends Domain {
    private static final String EVENT_ENVELOPE_NAME = "Microsoft.ApplicationInsights.Event";
    private static final String EVENT_BASE_TYPE = "EventData";
    private int ver = 2;
    private String name;
    private ConcurrentMap<String, String> properties;
    private ConcurrentMap<String, Double> measurements;

    public EventData() {
        this.InitializeFields();
    }

    public int getVer() {
        return this.ver;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConcurrentMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(ConcurrentMap<String, String> value) {
        this.properties = value;
    }

    public ConcurrentMap<String, Double> getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new ConcurrentHashMap<String, Double>();
        }
        return this.measurements;
    }

    public void setMeasurements(ConcurrentMap<String, Double> value) {
        this.measurements = value;
    }

    @Override
    protected void serializeContent(JsonTelemetryDataSerializer writer) throws IOException {
        Preconditions.checkNotNull((Object)writer, (Object)"writer must be a non-null value");
        writer.write("ver", this.ver);
        writer.write("name", this.name);
        writer.write("properties", this.properties);
        writer.write("measurements", this.measurements);
    }

    @Override
    public String getEnvelopName() {
        return EVENT_ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return EVENT_BASE_TYPE;
    }

    @Override
    protected void InitializeFields() {
    }
}

