/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.schemav2;

import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.schemav2.Domain;
import com.microsoft.applicationinsights.internal.schemav2.ExceptionDetails;
import com.microsoft.applicationinsights.telemetry.JsonSerializable;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExceptionData
extends Domain
implements JsonSerializable {
    public static final String EXCEPTION_ENVELOPE_NAME = "Microsoft.ApplicationInsights.Exception";
    public static final String EXCEPTION_BASE_TYPE = "ExceptionData";
    private int ver = 2;
    private String handledAt;
    private ArrayList<ExceptionDetails> exceptions;
    private SeverityLevel severityLevel = null;
    private ConcurrentMap<String, String> properties;
    private ConcurrentMap<String, Double> measurements;

    public ExceptionData() {
        this.InitializeFields();
    }

    public int getVer() {
        return this.ver;
    }

    public String getHandledAt() {
        return this.handledAt;
    }

    public void setHandledAt(String value) {
        this.handledAt = value;
    }

    public ArrayList<ExceptionDetails> getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        return this.exceptions;
    }

    public void setExceptions(ArrayList<ExceptionDetails> value) {
        this.exceptions = value;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(SeverityLevel value) {
        this.severityLevel = value;
    }

    public ConcurrentMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(ConcurrentMap<String, String> value) {
        this.properties = value;
    }

    public ConcurrentMap<String, Double> getMeasurements() {
        if (this.measurements == null) {
            this.measurements = new ConcurrentHashMap<String, Double>();
        }
        return this.measurements;
    }

    public void setMeasurements(ConcurrentMap<String, Double> value) {
        this.measurements = value;
    }

    @Override
    protected void serializeContent(JsonTelemetryDataSerializer writer) throws IOException {
        Preconditions.checkNotNull((Object)writer, (Object)"writer must be a non-null value");
        super.serializeContent(writer);
        writer.write("ver", this.ver);
        writer.write("handledAt", this.handledAt);
        writer.write("exceptions", this.exceptions);
        writer.write("measurements", this.measurements);
        if (this.severityLevel != null) {
            writer.write("severityLevel", this.severityLevel.toString());
        }
        writer.write("properties", this.properties);
        writer.write("measurements", this.measurements);
    }

    @Override
    public String getEnvelopName() {
        return EXCEPTION_ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return EXCEPTION_BASE_TYPE;
    }

    @Override
    protected void InitializeFields() {
    }
}

