/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class MapUtil {
    public static <Value> void copy(Map<String, Value> source, Map<String, Value> target) {
        for (Map.Entry<String, Value> entry : source.entrySet()) {
            String key = entry.getKey();
            if (Strings.isNullOrEmpty((String)key) || target.containsKey(key)) continue;
            target.put(key, entry.getValue());
        }
    }

    public static <Key, Value> Value getValueOrNull(Map<Key, Value> map, Key key) {
        return map.containsKey(key) ? (Value)map.get(key) : null;
    }

    public static Boolean getBoolValueOrNull(Map<String, String> map, String key) {
        return map.containsKey(key) ? Boolean.valueOf(Boolean.parseBoolean(map.get(key))) : null;
    }

    public static Date getDateValueOrNull(Map<String, String> map, String key) {
        try {
            return map.containsKey(key) ? LocalStringsUtils.getDateFormatter().parse(map.get(key)) : null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static void setStringValueOrRemove(Map<String, String> map, String key, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public static void setBoolValueOrRemove(Map<String, String> map, String key, Boolean value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value != false ? "true" : "false");
        }
    }

    public static void setDateValueOrRemove(Map<String, String> map, String key, Date value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, LocalStringsUtils.getDateFormatter().format(value));
        }
    }
}

