/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.config.TelemetryConfigurationFactory;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import java.util.ArrayList;
import java.util.List;

public final class TelemetryConfiguration {
    private static final Object s_lock = new Object();
    private static volatile boolean initialized = false;
    private static TelemetryConfiguration active;
    private String instrumentationKey;
    private final ArrayList<ContextInitializer> contextInitializers = new ArrayList();
    private final ArrayList<TelemetryInitializer> telemetryInitializers = new ArrayList();
    private final ArrayList<TelemetryModule> telemetryModules = new ArrayList();
    private final ArrayList<TelemetryProcessor> telemetryProcessors = new ArrayList();
    private TelemetryChannel channel;
    private boolean trackingIsDisabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelemetryConfiguration getActive() {
        if (!initialized) {
            Object object = s_lock;
            synchronized (object) {
                if (!initialized) {
                    active = new TelemetryConfiguration();
                    TelemetryConfigurationFactory.INSTANCE.initialize(active);
                    initialized = true;
                }
            }
        }
        return active;
    }

    public static TelemetryConfiguration createDefault() {
        TelemetryConfiguration telemetryConfiguration = new TelemetryConfiguration();
        TelemetryConfigurationFactory.INSTANCE.initialize(telemetryConfiguration);
        return telemetryConfiguration;
    }

    public TelemetryChannel getChannel() {
        return this.channel;
    }

    public void setChannel(TelemetryChannel channel) {
        this.channel = channel;
    }

    public boolean isTrackingDisabled() {
        return this.trackingIsDisabled;
    }

    public void setTrackingIsDisabled(boolean disable) {
        this.trackingIsDisabled = disable;
    }

    public List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    public List<TelemetryInitializer> getTelemetryInitializers() {
        return this.telemetryInitializers;
    }

    public List<TelemetryModule> getTelemetryModules() {
        return this.telemetryModules;
    }

    public List<TelemetryProcessor> getTelemetryProcessors() {
        return this.telemetryProcessors;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public void setInstrumentationKey(String key) {
        if (!Sanitizer.isUUID(key)) {
            InternalLogger.INSTANCE.trace("Telemetry Configuration: instrumentation key '%s' is not in UUID format", key);
        }
        if (Strings.isNullOrEmpty((String)key)) {
            throw new IllegalArgumentException("key");
        }
        this.instrumentationKey = key;
    }
}

