/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.channel.concrete.inprocess;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannelFactory;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.channel.TransmitterFactory;
import com.microsoft.applicationinsights.internal.channel.common.TelemetryBuffer;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LimitsEnforcer;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class InProcessTelemetryChannel
implements TelemetryChannel {
    private static final int DEFAULT_MAX_TELEMETRY_BUFFER_CAPACITY = 500;
    private static final int MIN_MAX_TELEMETRY_BUFFER_CAPACITY = 1;
    private static final int MAX_MAX_TELEMETRY_BUFFER_CAPACITY = 1000;
    private static final String MAX_MAX_TELEMETRY_BUFFER_CAPACITY_NAME = "MaxTelemetryBufferCapacity";
    private static final int DEFAULT_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 5;
    private static final int MIN_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 1;
    private static final int MAX_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 300;
    private static final String FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME = "FlushIntervalInSeconds";
    private static final String DEVELOPER_MODE_NAME = "DeveloperMode";
    private static final String ENDPOINT_ADDRESS_NAME = "EndpointAddress";
    private static final String MAX_TRANSMISSION_STORAGE_CAPACITY_NAME = "MaxTransmissionStorageFilesCapacityInMB";
    private boolean developerMode = false;
    private static TransmitterFactory s_transmitterFactory;
    private boolean stopped = false;
    private TelemetriesTransmitter telemetriesTransmitter;
    private TelemetryBuffer telemetryBuffer;

    public InProcessTelemetryChannel() {
        this(null, false);
    }

    public InProcessTelemetryChannel(String endpointAddress, boolean developerMode) {
        this.initialize(endpointAddress, null, developerMode, this.createDefaultMaxTelemetryBufferCapacityEnforcer(null), this.createDefaultSendIntervalInSecondsEnforcer(null), true);
    }

    public InProcessTelemetryChannel(String endpointAddress, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis) {
        this.initialize(endpointAddress, null, developerMode, this.createDefaultMaxTelemetryBufferCapacityEnforcer(maxTelemetryBufferCapacity), this.createDefaultSendIntervalInSecondsEnforcer(sendIntervalInMillis), true);
    }

    public InProcessTelemetryChannel(Map<String, String> namesAndValues) {
        boolean developerMode = false;
        String endpointAddress = null;
        LimitsEnforcer maxTelemetryBufferCapacityEnforcer = this.createDefaultMaxTelemetryBufferCapacityEnforcer(null);
        LimitsEnforcer sendIntervalInSecondsEnforcer = this.createDefaultSendIntervalInSecondsEnforcer(null);
        boolean throttling = true;
        if (namesAndValues != null) {
            throttling = Boolean.valueOf(namesAndValues.get("Throttling"));
            developerMode = Boolean.valueOf(namesAndValues.get(DEVELOPER_MODE_NAME));
            endpointAddress = namesAndValues.get(ENDPOINT_ADDRESS_NAME);
            maxTelemetryBufferCapacityEnforcer.normalizeStringValue(namesAndValues.get(MAX_MAX_TELEMETRY_BUFFER_CAPACITY_NAME));
            sendIntervalInSecondsEnforcer.normalizeStringValue(namesAndValues.get(FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME));
        }
        String maxTransmissionStorageCapacity = namesAndValues.get(MAX_TRANSMISSION_STORAGE_CAPACITY_NAME);
        this.initialize(endpointAddress, maxTransmissionStorageCapacity, developerMode, maxTelemetryBufferCapacityEnforcer, sendIntervalInSecondsEnforcer, throttling);
    }

    @Override
    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    @Override
    public void setDeveloperMode(boolean developerMode) {
        if (developerMode != this.developerMode) {
            this.developerMode = developerMode;
            int maxTelemetriesInBatch = this.developerMode ? 1 : 500;
            this.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
        }
    }

    @Override
    public void send(Telemetry telemetry) {
        Preconditions.checkNotNull((Object)telemetry, (Object)"Telemetry item must be non null");
        if (this.isDeveloperMode()) {
            telemetry.getContext().getProperties().put(DEVELOPER_MODE_NAME, "true");
        }
        StringWriter writer = new StringWriter();
        JsonTelemetryDataSerializer jsonWriter = null;
        try {
            jsonWriter = new JsonTelemetryDataSerializer(writer);
            telemetry.serialize(jsonWriter);
            jsonWriter.close();
            String asJson = writer.toString();
            this.telemetryBuffer.add(asJson);
        }
        catch (IOException e) {
            InternalLogger.INSTANCE.error("Failed to serialize Telemetry", new Object[0]);
            return;
        }
        if (this.isDeveloperMode()) {
            this.writeTelemetryToDebugOutput(telemetry);
        }
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        try {
            if (this.stopped) {
                return;
            }
            this.telemetriesTransmitter.stop(timeout, timeUnit);
            this.stopped = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
        this.telemetryBuffer.flush();
    }

    public void setMaxTelemetriesInBatch(int maxTelemetriesInBatch) {
        this.telemetryBuffer.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
    }

    public void setTransmitBufferTimeoutInSeconds(int transmitBufferTimeoutInSeconds) {
        this.telemetryBuffer.setTransmitBufferTimeoutInSeconds(transmitBufferTimeoutInSeconds);
    }

    private void writeTelemetryToDebugOutput(Telemetry telemetry) {
        InternalLogger.INSTANCE.trace("InProcessTelemetryChannel sending telemetry", new Object[0]);
    }

    private synchronized void initialize(String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, LimitsEnforcer maxTelemetryBufferCapacityEnforcer, LimitsEnforcer sendIntervalInSeconds, boolean throttling) {
        this.makeSureEndpointAddressIsValid(endpointAddress);
        if (s_transmitterFactory == null) {
            s_transmitterFactory = new InProcessTelemetryChannelFactory();
        }
        this.telemetriesTransmitter = s_transmitterFactory.create(endpointAddress, maxTransmissionStorageCapacity, throttling);
        this.telemetryBuffer = new TelemetryBuffer(this.telemetriesTransmitter, maxTelemetryBufferCapacityEnforcer, sendIntervalInSeconds);
        this.setDeveloperMode(developerMode);
    }

    private void makeSureEndpointAddressIsValid(String endpointAddress) {
        if (Strings.isNullOrEmpty((String)endpointAddress)) {
            return;
        }
        URI uri = Sanitizer.sanitizeUri(endpointAddress);
        if (uri == null) {
            String errorMessage = String.format("Endpoint address %s is not a valid uri", endpointAddress);
            InternalLogger.INSTANCE.error(errorMessage, new Object[0]);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private LimitsEnforcer createDefaultMaxTelemetryBufferCapacityEnforcer(Integer currentValue) {
        LimitsEnforcer maxItemsInBatchEnforcer = LimitsEnforcer.createWithClosestLimitOnError(MAX_MAX_TELEMETRY_BUFFER_CAPACITY_NAME, 1, 1000, 500, currentValue == null ? 500 : currentValue);
        return maxItemsInBatchEnforcer;
    }

    private LimitsEnforcer createDefaultSendIntervalInSecondsEnforcer(Integer currentValue) {
        LimitsEnforcer sendIntervalInSecondsEnforcer = LimitsEnforcer.createWithClosestLimitOnError(FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME, 1, 300, 5, currentValue == null ? 5 : currentValue);
        return sendIntervalInSecondsEnforcer;
    }
}

