/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TransmissionOutput;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicy;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyStateFetcher;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ActiveTransmissionFileSystemOutput
implements TransmissionOutput {
    private final ThreadPoolExecutor threadPool;
    private final TransmissionOutput actualOutput;
    private final TransmissionPolicyStateFetcher transmissionPolicy;

    public ActiveTransmissionFileSystemOutput(TransmissionOutput actualOutput, TransmissionPolicyStateFetcher transmissionPolicy) {
        Preconditions.checkNotNull((Object)transmissionPolicy, (Object)"transmissionPolicy must be a non-null value");
        this.actualOutput = actualOutput;
        this.transmissionPolicy = transmissionPolicy;
        this.threadPool = ThreadPoolUtils.newLimitedThreadPool(1, 3, 20L, 1024);
        this.threadPool.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @Override
    public boolean send(final Transmission transmission) {
        try {
            if (this.transmissionPolicy.getCurrentState() == TransmissionPolicy.BLOCKED_AND_CANNOT_BE_PERSISTED) {
                return false;
            }
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveTransmissionFileSystemOutput.this.actualOutput.send(transmission);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        this.actualOutput.stop(timeout, timeUnit);
        ThreadPoolUtils.stop(this.threadPool, timeout, timeUnit);
    }
}

