/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicy;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyState;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyStateFetcher;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class TransmissionPolicyManager
implements Stoppable {
    private Date suspensionDate = null;
    private AtomicLong generation = new AtomicLong(0L);
    private ScheduledThreadPoolExecutor threads;
    private final TransmissionPolicyState policyState = new TransmissionPolicyState();
    private boolean throttlingIsEnabled = true;

    public TransmissionPolicyManager(boolean throttlingIsEnabled) {
        this.throttlingIsEnabled = throttlingIsEnabled;
    }

    public void suspendInSeconds(TransmissionPolicy policy, long suspendInSeconds) {
        if (!this.throttlingIsEnabled) {
            return;
        }
        Preconditions.checkArgument((suspendInSeconds > 0L ? 1 : 0) != 0, (Object)"Suspension must be greater than zero");
        this.createScheduler();
        this.doSuspend(policy, suspendInSeconds);
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        ThreadPoolUtils.stop(this.threads, timeout, timeUnit);
    }

    public TransmissionPolicyStateFetcher getTransmissionPolicyState() {
        return this.policyState;
    }

    private synchronized void doSuspend(TransmissionPolicy policy, long suspendInSeconds) {
        try {
            long diff;
            if (policy == TransmissionPolicy.UNBLOCKED) {
                return;
            }
            Date date = Calendar.getInstance().getTime();
            date.setTime(date.getTime() + 1000L * suspendInSeconds);
            if (this.suspensionDate != null && (diff = date.getTime() - this.suspensionDate.getTime()) <= 0L) {
                return;
            }
            long currentGeneration = this.generation.incrementAndGet();
            this.threads.schedule(new UnSuspender(currentGeneration), suspendInSeconds, TimeUnit.SECONDS);
            this.policyState.setCurrentState(policy);
            this.suspensionDate = date;
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.TRACE, "App is throttled, telemetries are blocked from now, for %s seconds", suspendInSeconds);
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "App is throttled but failed to block transmission exception: %s", t.getMessage());
        }
    }

    private synchronized void cancelSuspension(long expectedGeneration) {
        if (expectedGeneration != this.generation.get()) {
            return;
        }
        this.policyState.setCurrentState(TransmissionPolicy.UNBLOCKED);
        this.suspensionDate = null;
        InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.TRACE, "App is throttled is cancelled", new Object[0]);
    }

    private synchronized void createScheduler() {
        if (this.threads != null) {
            return;
        }
        this.threads = new ScheduledThreadPoolExecutor(1);
        this.threads.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        SDKShutdownActivity.INSTANCE.register(this);
    }

    private class UnSuspender
    implements Runnable {
        private final long expectedGeneration;

        private UnSuspender(long expectedGeneration) {
            this.expectedGeneration = expectedGeneration;
        }

        @Override
        public void run() {
            try {
                TransmissionPolicyManager.this.cancelSuspension(this.expectedGeneration);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

