/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel;
import com.microsoft.applicationinsights.extensibility.PerformanceCountersCollectionPlugin;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.annotation.AnnotationPackageScanner;
import com.microsoft.applicationinsights.internal.annotation.BuiltInProcessor;
import com.microsoft.applicationinsights.internal.annotation.PerformanceModule;
import com.microsoft.applicationinsights.internal.config.AppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.ApplicationInsightsXmlConfiguration;
import com.microsoft.applicationinsights.internal.config.ChannelXmlElement;
import com.microsoft.applicationinsights.internal.config.ConfigurationFileLocator;
import com.microsoft.applicationinsights.internal.config.ContextInitializersInitializer;
import com.microsoft.applicationinsights.internal.config.ContextInitializersXmlElement;
import com.microsoft.applicationinsights.internal.config.JaxbAppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.JmxXmlElement;
import com.microsoft.applicationinsights.internal.config.PerformanceCountersXmlElement;
import com.microsoft.applicationinsights.internal.config.ReflectionUtils;
import com.microsoft.applicationinsights.internal.config.SDKLoggerXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryInitializersXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryModulesXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryProcessorCreator;
import com.microsoft.applicationinsights.internal.config.TelemetryProcessorXmlElement;
import com.microsoft.applicationinsights.internal.config.TelemetryProcessorsXmlElement;
import com.microsoft.applicationinsights.internal.jmx.JmxAttributeData;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.JmxMetricPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterConfigurationAware;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounterContainer;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TelemetryConfigurationFactory {
    INSTANCE;

    private static final String CONFIG_FILE_NAME = "ApplicationInsights.xml";
    private static final String DEFAULT_PERFORMANCE_MODULES_PACKAGE = "com.microsoft.applicationinsights";
    private static final String BUILT_IN_NAME = "BuiltIn";
    private String performanceCountersSection = "com.microsoft.applicationinsights";
    static final String EXTERNAL_PROPERTY_IKEY_NAME = "APPLICATION_INSIGHTS_IKEY";
    private AppInsightsConfigurationBuilder builder = new JaxbAppInsightsConfigurationBuilder();

    public final void initialize(TelemetryConfiguration configuration) {
        try {
            InputStream configurationFile = new ConfigurationFileLocator(CONFIG_FILE_NAME).getConfigurationFile();
            if (configurationFile == null) {
                this.setMinimumConfiguration(null, configuration);
                return;
            }
            ApplicationInsightsXmlConfiguration applicationInsightsConfig = this.builder.build(configurationFile);
            if (applicationInsightsConfig == null) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to read configuration file", new Object[0]);
                this.setMinimumConfiguration(applicationInsightsConfig, configuration);
                return;
            }
            this.setInternalLogger(applicationInsightsConfig.getSdkLogger(), configuration);
            this.setInstrumentationKey(applicationInsightsConfig, configuration);
            this.setChannel(applicationInsightsConfig.getChannel(), configuration);
            configuration.setTrackingIsDisabled(applicationInsightsConfig.isDisableTelemetry());
            this.setContextInitializers(applicationInsightsConfig.getContextInitializers(), configuration);
            this.setTelemetryInitializers(applicationInsightsConfig.getTelemetryInitializers(), configuration);
            this.setTelemetryModules(applicationInsightsConfig, configuration);
            this.setTelemetryProcessors(applicationInsightsConfig, configuration);
            this.initializeComponents(configuration);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to initialize configuration, exception: %s", e.getMessage());
        }
    }

    private void setMinimumConfiguration(ApplicationInsightsXmlConfiguration userConfiguration, TelemetryConfiguration configuration) {
        this.setInstrumentationKey(userConfiguration, configuration);
        configuration.setChannel(new InProcessTelemetryChannel());
        this.setContextInitializers(null, configuration);
    }

    private void setInternalLogger(SDKLoggerXmlElement sdkLogger, TelemetryConfiguration configuration) {
        if (sdkLogger == null) {
            return;
        }
        InternalLogger.INSTANCE.initialize(sdkLogger.getType(), sdkLogger.getData());
    }

    private void setTelemetryInitializers(TelemetryInitializersXmlElement telemetryInitializers, TelemetryConfiguration configuration) {
        if (telemetryInitializers == null) {
            return;
        }
        List<TelemetryInitializer> initializerList = configuration.getTelemetryInitializers();
        ReflectionUtils.loadComponents(TelemetryInitializer.class, initializerList, telemetryInitializers.getAdds());
    }

    private void setContextInitializers(ContextInitializersXmlElement contextInitializers, TelemetryConfiguration configuration) {
        new ContextInitializersInitializer().initialize(contextInitializers, configuration);
    }

    private void setTelemetryModules(ApplicationInsightsXmlConfiguration appConfiguration, TelemetryConfiguration configuration) {
        TelemetryModulesXmlElement configurationModules = appConfiguration.getModules();
        List<TelemetryModule> modules = configuration.getTelemetryModules();
        if (configurationModules != null) {
            ReflectionUtils.loadComponents(TelemetryModule.class, modules, configurationModules.getAdds());
        }
        List<TelemetryModule> pcModules = this.getPerformanceModules(appConfiguration.getPerformance());
        modules.addAll(pcModules);
    }

    private void setTelemetryProcessors(ApplicationInsightsXmlConfiguration appConfiguration, TelemetryConfiguration configuration) {
        TelemetryProcessorsXmlElement configurationProcessors = appConfiguration.getTelemetryProcessors();
        List<TelemetryProcessor> processors = configuration.getTelemetryProcessors();
        if (configurationProcessors != null) {
            ArrayList<TelemetryProcessorXmlElement> b = configurationProcessors.getBuiltInTelemetryProcessors();
            if (!b.isEmpty()) {
                List<String> processorsBuiltInNames = new AnnotationPackageScanner().scanForClassAnnotations(new Class[]{BuiltInProcessor.class}, this.performanceCountersSection);
                HashMap<String, String> builtInMap = new HashMap<String, String>();
                for (String processorsBuiltInName : processorsBuiltInNames) {
                    builtInMap.put(processorsBuiltInName.substring(processorsBuiltInName.lastIndexOf(".") + 1), processorsBuiltInName);
                }
                ArrayList<TelemetryProcessorXmlElement> validProcessors = new ArrayList<TelemetryProcessorXmlElement>();
                for (TelemetryProcessorXmlElement element : b) {
                    String fullTypeName = (String)builtInMap.get(element.getType());
                    if (LocalStringsUtils.isNullOrEmpty(fullTypeName)) {
                        InternalLogger.INSTANCE.error("Failed to find built in processor: '%s', ignored", element.getType());
                        continue;
                    }
                    element.setType(fullTypeName);
                    validProcessors.add(element);
                }
                this.loadProcessorComponents(processors, validProcessors);
            }
            ArrayList<TelemetryProcessorXmlElement> customs = configurationProcessors.getCustomTelemetryProcessors();
            this.loadProcessorComponents(processors, customs);
        }
    }

    private void setInstrumentationKey(ApplicationInsightsXmlConfiguration userConfiguration, TelemetryConfiguration configuration) {
        try {
            String ikey = System.getProperty(EXTERNAL_PROPERTY_IKEY_NAME);
            if (!Strings.isNullOrEmpty((String)ikey)) {
                configuration.setInstrumentationKey(ikey);
                return;
            }
            ikey = System.getenv(EXTERNAL_PROPERTY_IKEY_NAME);
            if (!Strings.isNullOrEmpty((String)ikey)) {
                configuration.setInstrumentationKey(ikey);
                return;
            }
            if (userConfiguration != null) {
                ikey = userConfiguration.getInstrumentationKey();
                if (ikey == null) {
                    return;
                }
                if ((ikey = ikey.trim()).length() == 0) {
                    return;
                }
                configuration.setInstrumentationKey(ikey);
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to set instrumentation key: '%s'", e.getMessage());
        }
    }

    private List<TelemetryProcessor> getTelemetryProcessors() {
        ArrayList<TelemetryProcessor> processors = new ArrayList<TelemetryProcessor>();
        return processors;
    }

    private List<TelemetryModule> getPerformanceModules(PerformanceCountersXmlElement performanceConfigurationData) {
        PerformanceCounterContainer.INSTANCE.setCollectionFrequencyInSec(performanceConfigurationData.getCollectionFrequencyInSec());
        String pluginName = performanceConfigurationData.getPlugin();
        PerformanceCountersCollectionPlugin plugin = ReflectionUtils.createInstance(pluginName, PerformanceCountersCollectionPlugin.class);
        PerformanceCounterContainer.INSTANCE.setPlugin(plugin);
        ArrayList<TelemetryModule> modules = new ArrayList<TelemetryModule>();
        List<String> performanceModuleNames = new AnnotationPackageScanner().scanForClassAnnotations(new Class[]{PerformanceModule.class}, this.performanceCountersSection);
        if (performanceModuleNames.size() == 0) {
            performanceModuleNames.addAll(this.getDefaultPerformanceModulesNames());
        }
        for (String performanceModuleName : performanceModuleNames) {
            TelemetryModule module = this.createInstance(performanceModuleName, TelemetryModule.class);
            if (module != null) {
                PerformanceModule pmAnnotation = module.getClass().getAnnotation(PerformanceModule.class);
                if (!performanceConfigurationData.isUseBuiltIn() && BUILT_IN_NAME.equals(pmAnnotation.value())) continue;
                if (module instanceof PerformanceCounterConfigurationAware) {
                    PerformanceCounterConfigurationAware awareModule = (PerformanceCounterConfigurationAware)((Object)module);
                    try {
                        awareModule.addConfigurationData(performanceConfigurationData);
                    }
                    catch (Exception e) {
                        InternalLogger.INSTANCE.error("Failed to add configuration data to performance module: '%s'", e.getMessage());
                    }
                }
                modules.add(module);
                continue;
            }
            InternalLogger.INSTANCE.error("Failed to create performance module: '%s'", performanceModuleName);
        }
        this.loadCustomJmxPCs(performanceConfigurationData.getJmxXmlElements());
        return modules;
    }

    private List<String> getDefaultPerformanceModulesNames() {
        InternalLogger.INSTANCE.trace("Default performance counters will be automatically loaded.", new Object[0]);
        ArrayList<String> modules = new ArrayList<String>();
        modules.add("com.microsoft.applicationinsights.internal.perfcounter.ProcessPerformanceCountersModule");
        modules.add("com.microsoft.applicationinsights.web.internal.perfcounter.WebPerformanceCounterModule");
        return modules;
    }

    private void loadCustomJmxPCs(ArrayList<JmxXmlElement> jmxXmlElements) {
        try {
            if (jmxXmlElements == null) {
                return;
            }
            HashMap data = new HashMap();
            for (JmxXmlElement jmxXmlElement : jmxXmlElements) {
                ArrayList<JmxAttributeData> collection = (ArrayList<JmxAttributeData>)data.get(jmxXmlElement.getObjectName());
                if (collection == null) {
                    collection = new ArrayList<JmxAttributeData>();
                    data.put(jmxXmlElement.getObjectName(), collection);
                }
                if (Strings.isNullOrEmpty((String)jmxXmlElement.getObjectName())) {
                    InternalLogger.INSTANCE.error("JMX object name is empty, will be ignored", new Object[0]);
                    continue;
                }
                if (Strings.isNullOrEmpty((String)jmxXmlElement.getAttribute())) {
                    InternalLogger.INSTANCE.error("JMX attribute is empty for '%s', will be ignored", jmxXmlElement.getObjectName());
                    continue;
                }
                if (Strings.isNullOrEmpty((String)jmxXmlElement.getDisplayName())) {
                    InternalLogger.INSTANCE.error("JMX display name is empty for '%s', will be ignored", jmxXmlElement.getObjectName());
                    continue;
                }
                collection.add(new JmxAttributeData(jmxXmlElement.getDisplayName(), jmxXmlElement.getAttribute(), jmxXmlElement.getType()));
            }
            for (Map.Entry entry : data.entrySet()) {
                try {
                    if (PerformanceCounterContainer.INSTANCE.register(new JmxMetricPerformanceCounter((String)entry.getKey(), (String)entry.getKey(), (Collection)entry.getValue()))) {
                        InternalLogger.INSTANCE.trace("Registered JMX performance counter '%s'", entry.getKey());
                        continue;
                    }
                    InternalLogger.INSTANCE.trace("Failed to register JMX performance counter '%s'", entry.getKey());
                }
                catch (Exception e) {
                    InternalLogger.INSTANCE.error("Failed to register JMX performance counter '%s': '%s'", entry.getKey(), e.getMessage());
                }
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to register JMX performance counters: '%s'", e.getMessage());
        }
    }

    private boolean setChannel(ChannelXmlElement channelXmlElement, TelemetryConfiguration configuration) {
        String channelName = channelXmlElement.getType();
        if (channelName != null) {
            TelemetryChannel channel = this.createInstance(channelName, TelemetryChannel.class, Map.class, channelXmlElement.getData());
            if (channel != null) {
                configuration.setChannel(channel);
                return true;
            }
            InternalLogger.INSTANCE.error("Failed to create '%s', will create the default one with default arguments", channelName);
        }
        try {
            configuration.setChannel(new InProcessTelemetryChannel(channelXmlElement.getData()));
            return true;
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to create InProcessTelemetryChannel, exception: %s, will create the default one with default arguments", e.getMessage());
            configuration.setChannel(new InProcessTelemetryChannel());
            return true;
        }
    }

    private void loadProcessorComponents(List<TelemetryProcessor> list, Collection<TelemetryProcessorXmlElement> classesFromConfigration) {
        if (classesFromConfigration == null) {
            return;
        }
        TelemetryProcessorCreator creator = new TelemetryProcessorCreator();
        for (TelemetryProcessorXmlElement classData : classesFromConfigration) {
            TelemetryProcessor processor = creator.Create(classData);
            if (processor == null) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Processor " + classData.getType() + " failure during initialization", new Object[0]);
                continue;
            }
            InternalLogger.INSTANCE.trace("Processor " + classData.getType() + " was added successfully", new Object[0]);
            list.add(processor);
        }
    }

    private <T> T createInstance(String className, Class<T> interfaceClass) {
        new ReflectionUtils();
        return ReflectionUtils.createInstance(className, interfaceClass);
    }

    private <T, A> T createInstance(String className, Class<T> interfaceClass, Class<A> argumentClass, A argument) {
        return ReflectionUtils.createInstance(className, interfaceClass, argumentClass, argument);
    }

    private void initializeComponents(TelemetryConfiguration configuration) {
        List<TelemetryModule> telemetryModules = configuration.getTelemetryModules();
        for (TelemetryModule module : telemetryModules) {
            try {
                module.initialize(configuration);
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to initialized telemetry module " + module.getClass().getSimpleName() + ". Excepption", new Object[0]);
            }
        }
    }

    void setPerformanceCountersSection(String performanceCountersSection) {
        this.performanceCountersSection = performanceCountersSection;
    }

    void setBuilder(AppInsightsConfigurationBuilder builder) {
        this.builder = builder;
    }
}

