/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter.jvm;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

public final class GCPerformanceCounter
implements PerformanceCounter {
    public static final String NAME = "GC";
    private static final String GC_TOTAL_COUNT = "GC Total Count";
    private static final String GC_TOTAL_TIME = "GC Total Time";
    private long currentTotalCount = 0L;
    private long currentTotalTime = 0L;

    @Override
    public String getId() {
        return "GCPerformanceCounter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(TelemetryClient telemetryClient) {
        GCPerformanceCounter gCPerformanceCounter = this;
        synchronized (gCPerformanceCounter) {
            List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
            if (gcs == null) {
                return;
            }
            long totalCollectionCount = 0L;
            long totalCollectionTime = 0L;
            for (GarbageCollectorMXBean gc : gcs) {
                long gcCollectionTime;
                long gcCollectionCount = gc.getCollectionCount();
                if (gcCollectionCount > 0L) {
                    totalCollectionCount += gcCollectionCount;
                }
                if ((gcCollectionTime = gc.getCollectionTime()) <= 0L) continue;
                totalCollectionTime += gcCollectionTime;
            }
            long countToReport = totalCollectionCount - this.currentTotalCount;
            long timeToReport = totalCollectionTime - this.currentTotalTime;
            this.currentTotalCount = totalCollectionCount;
            this.currentTotalTime = totalCollectionTime;
            MetricTelemetry mtTotalCount = new MetricTelemetry(GC_TOTAL_COUNT, countToReport);
            MetricTelemetry mtTotalTime = new MetricTelemetry(GC_TOTAL_TIME, timeToReport);
            telemetryClient.track(mtTotalCount);
            telemetryClient.track(mtTotalTime);
        }
    }
}

