/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter.jvm;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class JvmHeapMemoryUsedPerformanceCounter
implements PerformanceCounter {
    public static final String NAME = "MemoryUsage";
    private static final String HEAP_MEM_USED = "Heap Memory Used (MB)";
    private final long Megabyte = 0x100000L;
    private final MemoryMXBean memory = ManagementFactory.getMemoryMXBean();

    @Override
    public String getId() {
        return "JvmHeapMemoryUsedPerformanceCounter";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        if (this.memory == null) {
            return;
        }
        this.reportHeap(this.memory, telemetryClient);
    }

    private void reportHeap(MemoryMXBean memory, TelemetryClient telemetryClient) {
        MemoryUsage mhu = memory.getHeapMemoryUsage();
        if (mhu != null) {
            long currentHeapUsed = mhu.getUsed() / 0x100000L;
            MetricTelemetry memoryHeapUsage = new MetricTelemetry(HEAP_MEM_USED, currentHeapUsed);
            telemetryClient.track(memoryHeapUsage);
        }
    }
}

