/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.core.dependencies.xstream.converters.collections;

import com.microsoft.applicationinsights.core.dependencies.xstream.converters.MarshallingContext;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.UnmarshallingContext;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.collections.CollectionConverter;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.collections.TreeMapConverter;
import com.microsoft.applicationinsights.core.dependencies.xstream.converters.reflection.ObjectAccessException;
import com.microsoft.applicationinsights.core.dependencies.xstream.core.JVM;
import com.microsoft.applicationinsights.core.dependencies.xstream.core.util.Fields;
import com.microsoft.applicationinsights.core.dependencies.xstream.core.util.PresortedSet;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.HierarchicalStreamReader;
import com.microsoft.applicationinsights.core.dependencies.xstream.io.HierarchicalStreamWriter;
import com.microsoft.applicationinsights.core.dependencies.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TreeSetConverter
extends CollectionConverter {
    private transient TreeMapConverter treeMapConverter;
    private static final Field sortedMapField;
    private static final Object constantValue;

    public TreeSetConverter(Mapper mapper) {
        super(mapper, TreeSet.class);
        this.readResolve();
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SortedSet sortedSet = (SortedSet)source;
        this.treeMapConverter.marshalComparator(sortedSet.comparator(), writer, context);
        super.marshal(source, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeMap treeMap;
        Comparator comparator;
        TreeSet result = null;
        Comparator unmarshalledComparator = this.treeMapConverter.unmarshalComparator(reader, context, null);
        boolean inFirstElement = unmarshalledComparator instanceof Mapper.Null;
        Comparator comparator2 = comparator = inFirstElement ? null : unmarshalledComparator;
        if (sortedMapField != null) {
            TreeSet possibleResult = comparator == null ? new TreeSet() : new TreeSet(comparator);
            Object backingMap = null;
            try {
                backingMap = sortedMapField.get(possibleResult);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Cannot get backing map of TreeSet", e);
            }
            if (backingMap instanceof TreeMap) {
                treeMap = (TreeMap)backingMap;
                result = possibleResult;
            } else {
                treeMap = null;
            }
        } else {
            treeMap = null;
        }
        if (treeMap == null) {
            PresortedSet set = new PresortedSet(comparator);
            TreeSet treeSet = result = comparator == null ? new TreeSet() : new TreeSet(comparator);
            if (inFirstElement) {
                this.addCurrentElementToCollection(reader, context, result, set);
                reader.moveUp();
            }
            this.populateCollection(reader, context, result, set);
            if (set.size() > 0) {
                result.addAll(set);
            }
        } else {
            this.treeMapConverter.populateTreeMap(reader, context, treeMap, unmarshalledComparator);
        }
        return result;
    }

    private Object readResolve() {
        this.treeMapConverter = new TreeMapConverter(this.mapper()){

            protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, final Map target) {
                TreeSetConverter.this.populateCollection(reader, context, new AbstractList(){

                    public boolean add(Object object) {
                        return target.put(object, constantValue != null ? constantValue : object) != null;
                    }

                    public Object get(int location) {
                        return null;
                    }

                    public int size() {
                        return target.size();
                    }
                });
            }

            protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
                Object key = this.readItem(reader, context, map);
                target.put(key, key);
            }
        };
        return this;
    }

    static {
        Object value = null;
        Field field = JVM.hasOptimizedTreeSetAddAll() ? Fields.locate(TreeSet.class, SortedMap.class, false) : (sortedMapField = null);
        if (sortedMapField != null) {
            Object[] values;
            TreeSet<String> set = new TreeSet<String>();
            set.add("1");
            set.add("2");
            Map backingMap = null;
            try {
                backingMap = (Map)sortedMapField.get(set);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (backingMap != null && (values = backingMap.values().toArray())[0] == values[1]) {
                value = values[0];
            }
        } else {
            Field valueField = Fields.locate(TreeSet.class, Object.class, true);
            if (valueField != null) {
                try {
                    value = valueField.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        constantValue = value;
    }
}

