/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateTimeUtils {
    private static final String ROUND_TRIP_DATE_FORMAT = "yyyy-MM-dd'T'HH";

    private DateTimeUtils() {
    }

    public static Date getDateTimeNow() {
        return new Date();
    }

    public static Date addToDate(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static long getDateDiff(Date laterDate, Date date, TimeUnit timeUnit) {
        long diffInMs = laterDate.getTime() - date.getTime();
        return timeUnit.convert(diffInMs, TimeUnit.MILLISECONDS);
    }

    public static Date parseRoundTripDateString(String roundTripString) throws ParseException {
        SimpleDateFormat roundTripDateFormat = new SimpleDateFormat(ROUND_TRIP_DATE_FORMAT);
        Date date = roundTripDateFormat.parse(roundTripString);
        return date;
    }

    public static String formatAsRoundTripDate(Date date) {
        SimpleDateFormat roundTripDateFormat = new SimpleDateFormat(ROUND_TRIP_DATE_FORMAT);
        return roundTripDateFormat.format(date);
    }
}

