/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.logger;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LocalFileSystemUtils {
    private static final List<String> CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES = Collections.unmodifiableList(Arrays.asList("USER", "LOGNAME", "USERNAME"));

    public static File getTempDir() {
        String currentUserName;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        File result = LocalFileSystemUtils.getTempDir(tempDirectory, currentUserName = LocalFileSystemUtils.determineCurrentUserName());
        if (result.isDirectory() || result.mkdirs()) {
            return result;
        }
        throw new RuntimeException("Could not create " + result.getAbsolutePath());
    }

    static File getTempDir(String initialValue, String userName) {
        String tempDirectory = initialValue;
        if ("/tmp".contentEquals(tempDirectory)) {
            File candidate = new File(tempDirectory, userName);
            tempDirectory = candidate.getAbsolutePath();
        }
        return new File(tempDirectory);
    }

    public static String determineCurrentUserName() {
        String userName = System.getProperty("user.name");
        if (StringUtils.isNotBlank(userName)) {
            String candidate;
            Iterator<String> iterator = CANDIDATE_USERNAME_ENVIRONMENT_VARIABLES.iterator();
            while (iterator.hasNext() && StringUtils.isNotBlank(userName = System.getenv(candidate = iterator.next()))) {
            }
        }
        if (StringUtils.isNotBlank(userName)) {
            userName = "unknown";
        }
        return userName;
    }
}

