/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.core.dependencies.http.Header;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandler;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandlerArgs;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicy;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyManager;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ThrottlingHandler
implements TransmissionHandler {
    private TransmissionPolicyManager transmissionPolicyManager;
    private static final String RESPONSE_RETRY_AFTER_DATE_FORMAT = "E, dd MMM yyyy HH:mm:ss";

    public ThrottlingHandler(TransmissionPolicyManager policy) {
        this.transmissionPolicyManager = policy;
    }

    @Override
    public void onTransmissionSent(TransmissionHandlerArgs args) {
        this.validateTransmissionAndSend(args);
    }

    boolean validateTransmissionAndSend(TransmissionHandlerArgs args) {
        if (args.getRetryHeader() != null && args.getTransmission() != null && args.getTransmissionDispatcher() != null) {
            args.getTransmission().incrementNumberOfSends();
            switch (args.getResponseCode()) {
                case 429: 
                case 439: {
                    this.suspendTransmissions(TransmissionPolicy.BLOCKED_BUT_CAN_BE_PERSISTED, args.getRetryHeader());
                    args.getTransmissionDispatcher().dispatch(args.getTransmission());
                    return true;
                }
            }
            InternalLogger.INSTANCE.trace("Http response code %s not handled by %s", args.getResponseCode(), this.getClass().getName());
            return false;
        }
        InternalLogger.INSTANCE.trace("Http response code %s not handled by %s.", args.getResponseCode(), this.getClass().getName());
        return false;
    }

    private void suspendTransmissions(TransmissionPolicy suspensionPolicy, Header retryAfterHeader) {
        if (retryAfterHeader == null) {
            return;
        }
        String retryAfterAsString = retryAfterHeader.getValue();
        if (Strings.isNullOrEmpty(retryAfterAsString)) {
            return;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(RESPONSE_RETRY_AFTER_DATE_FORMAT);
            Date date = formatter.parse(retryAfterAsString);
            Date now = Calendar.getInstance().getTime();
            long retryAfterAsSeconds = (date.getTime() - ThrottlingHandler.convertToDateToGmt(now).getTime()) / 1000L;
            this.transmissionPolicyManager.suspendInSeconds(suspensionPolicy, retryAfterAsSeconds);
        }
        catch (Throwable e) {
            InternalLogger.INSTANCE.error("Throttled but failed to block transmission.%nStack Trace:%n%s", ExceptionUtils.getStackTrace(e));
            this.transmissionPolicyManager.backoff();
        }
    }

    private static Date convertToDateToGmt(Date date) {
        Date dstDate;
        Date ret;
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(ret = new Date(date.getTime() - (long)tz.getRawOffset())) && tz.inDaylightTime(dstDate = new Date(ret.getTime() - (long)tz.getDSTSavings()))) {
            ret = dstDate;
        }
        return ret;
    }
}

