/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.extensibility.context;

import com.microsoft.applicationinsights.extensibility.context.ContextTagKeys;
import com.microsoft.applicationinsights.internal.util.MapUtil;
import java.util.concurrent.ConcurrentMap;

public final class DeviceContext {
    private final ConcurrentMap<String, String> tags;

    public DeviceContext(ConcurrentMap<String, String> tags) {
        this.tags = tags;
    }

    public void setType(String type) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceType(), type);
    }

    public void setId(String id) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceId(), id);
    }

    public void setOperatingSystem(String operatingSystem) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceOS(), operatingSystem);
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceOSVersion(), operatingSystemVersion);
    }

    public void setOemName(String oemName) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceOEMName(), oemName);
    }

    public void setModel(String model) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceModel(), model);
    }

    public void setNetworkType(String networkType) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceNetwork(), networkType);
    }

    public void setScreenResolution(String screenResolution) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceScreenResolution(), screenResolution);
    }

    public void setLocale(String locale) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceLocale(), locale);
    }

    public void setLanguage(String language) {
        MapUtil.setStringValueOrRemove(this.tags, ContextTagKeys.getKeys().getDeviceLanguage(), language);
    }
}

