/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.log4j.v1_2;

import com.microsoft.applicationinsights.internal.common.LogTelemetryClientProxy;
import com.microsoft.applicationinsights.internal.common.TelemetryClientProxy;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.log4j.v1_2.internal.ApplicationInsightsLogEvent;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class ApplicationInsightsAppender
extends AppenderSkeleton {
    private boolean isInitialized = false;
    private String instrumentationKey;
    private TelemetryClientProxy telemetryClientProxy;

    public TelemetryClientProxy getTelemetryClientProxy() {
        return this.telemetryClientProxy;
    }

    public void setInstrumentationKey(String key) {
        this.instrumentationKey = key;
    }

    protected void append(LoggingEvent event) {
        if (this.closed || !this.isInitialized) {
            return;
        }
        try {
            ApplicationInsightsLogEvent aiEvent = new ApplicationInsightsLogEvent(event);
            this.telemetryClientProxy.sendEvent(aiEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        super.activateOptions();
        try {
            this.telemetryClientProxy = new LogTelemetryClientProxy(this.instrumentationKey);
            this.isInitialized = true;
        }
        catch (Exception e) {
            this.isInitialized = false;
            InternalLogger.INSTANCE.error("Failed to initialize appender with exception: %s.", new Object[]{e.getMessage()});
        }
    }
}

