/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.log4j.v1_2.internal;

import com.microsoft.applicationinsights.internal.common.ApplicationInsightsEvent;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public final class ApplicationInsightsLogEvent
extends ApplicationInsightsEvent {
    private LoggingEvent loggingEvent;

    public ApplicationInsightsLogEvent(LoggingEvent event) {
        this.loggingEvent = event;
    }

    @Override
    public String getMessage() {
        String message = this.loggingEvent.getRenderedMessage();
        return message != null ? message : "Log4j Trace";
    }

    @Override
    public boolean isException() {
        return this.loggingEvent.getThrowableInformation() != null;
    }

    @Override
    public Exception getException() {
        Exception exception = null;
        if (this.isException()) {
            Throwable throwable = this.loggingEvent.getThrowableInformation().getThrowable();
            exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        }
        return exception;
    }

    @Override
    public Map<String, String> getCustomParameters() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("SourceType", "Log4j");
        ApplicationInsightsLogEvent.addLogEventProperty("LoggerName", this.loggingEvent.getLoggerName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("LoggingLevel", this.loggingEvent.getLevel() != null ? this.loggingEvent.getLevel().toString() : null, metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("ThreadName", this.loggingEvent.getThreadName(), metaData);
        ApplicationInsightsLogEvent.addLogEventProperty("TimeStamp", ApplicationInsightsLogEvent.getFormattedDate(this.loggingEvent.getTimeStamp()), metaData);
        if (this.loggingEvent.locationInformationExists()) {
            LocationInfo locationInfo = this.loggingEvent.getLocationInformation();
            ApplicationInsightsLogEvent.addLogEventProperty("ClassName", locationInfo.getClassName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("FileName", locationInfo.getFileName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("MethodName", locationInfo.getMethodName(), metaData);
            ApplicationInsightsLogEvent.addLogEventProperty("LineNumber", String.valueOf(locationInfo.getLineNumber()), metaData);
        }
        Iterator iterator = this.loggingEvent.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            ApplicationInsightsLogEvent.addLogEventProperty((String)entry.getKey(), entry.getValue().toString(), metaData);
        }
        return metaData;
    }

    @Override
    public SeverityLevel getNormalizedSeverityLevel() {
        int log4jLevelAsInt = this.loggingEvent.getLevel().toInt();
        switch (log4jLevelAsInt) {
            case 50000: {
                return SeverityLevel.Critical;
            }
            case 40000: {
                return SeverityLevel.Error;
            }
            case 30000: {
                return SeverityLevel.Warning;
            }
            case 20000: {
                return SeverityLevel.Information;
            }
            case -2147483648: 
            case 5000: 
            case 10000: {
                return SeverityLevel.Verbose;
            }
        }
        InternalLogger.INSTANCE.error("Unknown Log4j v1.2 option, %d, using TRACE level as default", new Object[]{log4jLevelAsInt});
        return SeverityLevel.Verbose;
    }
}

