/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.cookies;

import com.microsoft.applicationinsights.internal.util.DateTimeUtils;
import com.microsoft.applicationinsights.web.internal.cookies.Cookie;
import java.text.ParseException;
import java.util.Date;

public class SessionCookie
extends Cookie {
    private static final int UPDATE_TIMEOUT_IN_MINUTES = 5;
    public static final String COOKIE_NAME = "ai_session";
    public static final int SESSION_DEFAULT_EXPIRATION_TIMEOUT_IN_MINUTES = 30;
    private String sessionId;
    private Date acquisitionDate;
    private Date renewalDate;

    public SessionCookie(javax.servlet.http.Cookie cookie) throws Exception {
        this.parseCookie(cookie);
    }

    public SessionCookie(String sessionId) {
        String now = String.valueOf(System.currentTimeMillis());
        String[] cookieRawValues = new String[]{sessionId, now, now};
        String formattedCookie = SessionCookie.formatCookie(cookieRawValues);
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(COOKIE_NAME, formattedCookie);
        try {
            this.parseCookie(cookie);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Date getSessionAcquisitionDate() {
        return this.acquisitionDate;
    }

    public Date getSessionRenewalDate() {
        return this.renewalDate;
    }

    public boolean isSessionExpired(int sessionTimeoutInMinutes) {
        Date expirationDate = DateTimeUtils.addToDate((Date)this.getSessionRenewalDate(), (int)12, (int)sessionTimeoutInMinutes);
        Date now = new Date();
        return now.after(expirationDate);
    }

    public boolean isSessionCookieUpToDate() {
        Date expectedRenewalTime = DateTimeUtils.addToDate((Date)this.getSessionRenewalDate(), (int)12, (int)5);
        Date now = new Date();
        return now.before(expectedRenewalTime);
    }

    private void parseCookie(javax.servlet.http.Cookie cookie) throws Exception {
        String[] split = cookie.getValue().split("\\|");
        if (split.length < CookieFields.values().length) {
            String errorMessage = String.format("Session cookie is not in the correct format: %s", cookie.getValue());
            throw new Exception(errorMessage);
        }
        try {
            this.sessionId = split[CookieFields.SESSION_ID.getValue()];
            this.acquisitionDate = this.parseDateWithBackwardCompatibility(split[CookieFields.SESSION_ACQUISITION_DATE.getValue()]);
            this.renewalDate = this.parseDateWithBackwardCompatibility(split[CookieFields.SESSION_LAST_UPDATE_DATE.getValue()]);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to parse session cookie with exception: %s", e.getMessage());
            throw new Exception(errorMessage);
        }
    }

    private Date parseDateWithBackwardCompatibility(String dateStr) throws ParseException {
        try {
            return new Date(Long.parseLong(dateStr));
        }
        catch (NumberFormatException e) {
            return DateTimeUtils.parseRoundTripDateString((String)dateStr);
        }
    }

    private static enum CookieFields {
        SESSION_ID(0),
        SESSION_ACQUISITION_DATE(1),
        SESSION_LAST_UPDATE_DATE(2);

        private final int value;

        private CookieFields(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

